/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api.rx;

import com.google.common.collect.Lists;
import com.onehilltech.promises.Promise;
import io.reactivex.Observable;
import io.reactivex.functions.Action;
import io.reactivex.subjects.BehaviorSubject;
import java.util.ArrayList;
import java.util.List;
import org.polkadot.api.ApiBase;
import org.polkadot.api.Types;
import org.polkadot.direct.IRpcFunction;
import org.polkadot.rpc.provider.IProvider;
import org.polkadot.utils.RxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRx
extends ApiBase<Observable> {
    private static final Logger logger = LoggerFactory.getLogger(ApiRx.class);
    private Observable<ApiRx> isReadyRx = RxUtils.fromPromise(new Promise(handler -> ApiRx.access$101(this, IProvider.ProviderInterfaceEmitted.ready, args -> handler.resolve((Object)this))));

    private ApiRx(IProvider provider) {
        super(provider, ApiBase.ApiType.RX);
    }

    public static Observable<ApiRx> create(IProvider provider) {
        ApiRx apiRx = new ApiRx(provider);
        return apiRx.isReadyRx;
    }

    @Override
    protected Observable onCall(final Types.OnCallFunction method, List<Object> params, boolean needCallback, IRpcFunction.SubscribeCallback callback) {
        if (!needCallback && callback == null) {
            Promise apply = method.apply(params.toArray(new Object[0]));
            return RxUtils.fromPromise(apply);
        }
        BehaviorSubject ret = null;
        if (needCallback && callback == null) {
            final BehaviorSubject subject = BehaviorSubject.create();
            callback = new IRpcFunction.SubscribeCallback(){

                public void callback(Object o) {
                    if (method instanceof ApiBase.StorageOnCallFunction && o instanceof List) {
                        subject.onNext(((List)o).get(0));
                    } else {
                        subject.onNext(o);
                    }
                }
            };
            ret = subject;
        }
        ArrayList args = Lists.newArrayList();
        if (params != null) {
            args.addAll(params);
        }
        args.add(callback);
        final Promise apply = method.apply(args.toArray(new Object[0]));
        if (ret != null) {
            ret = ret.doOnDispose(new Action(){

                public void run() throws Exception {
                    apply.then(result -> {
                        IRpcFunction.Unsubscribe unsubscribe = (IRpcFunction.Unsubscribe)result;
                        logger.debug(" doOnDispose unsub");
                        unsubscribe.unsubscribe();
                        return null;
                    })._catch(err -> {
                        err.printStackTrace();
                        return null;
                    });
                }
            });
            return ret;
        }
        return RxUtils.fromPromise(apply);
    }
}

