/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api.derive.accounts;

import com.onehilltech.promises.Promise;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.polkadot.api.Types;
import org.polkadot.api.derive.Types;
import org.polkadot.common.keyring.address.AddressCodec;
import org.polkadot.direct.ISection;
import org.polkadot.types.codec.Vector;
import org.polkadot.types.type.AccountId;
import org.polkadot.types.type.AccountIndex;
import org.polkadot.utils.Utils;

public class AccountFunctions {
    public static Types.DeriveRealFunction indexToId(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                ISection querySection = api.query().section("indices");
                if (querySection == null) {
                    querySection = api.query().section("balances");
                }
                AccountIndex accountIndex = args[0] instanceof AccountIndex ? (AccountIndex)args[0] : new AccountIndex(args[0]);
                return ((Promise)((Types.QueryableStorageFunction)querySection.function("enumSet")).call(accountIndex.divide(AccountIndex.ENUMSET_SIZE))).then(result -> {
                    Vector accountIds = null;
                    if (result != null) {
                        accountIds = (Vector)result;
                    }
                    int index = accountIndex.mod(AccountIndex.ENUMSET_SIZE).intValue();
                    if (accountIds != null && accountIds.size() > index) {
                        return Promise.value((Object)((AccountId)accountIds.get(index)));
                    }
                    return Promise.value(null);
                });
            }
        };
    }

    public static Types.DeriveRealFunction indexes(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                return ((Promise)((Types.QueryableStorageFunction)api.query().section("indices").function("nextEnumSet")).call(new Object[0])).then(result -> {
                    AccountIndex next = (AccountIndex)result;
                    ArrayList<Promise> list = new ArrayList<Promise>();
                    for (int index = 0; index < next.intValue() + 1; ++index) {
                        Promise call = (Promise)((Types.QueryableStorageFunction)api.query().section("indices").function("enumSet")).call(index);
                        list.add(call);
                    }
                    return Promise.all((Promise[])list.toArray(new Promise[0]));
                }).then(results -> {
                    AccountIndexes ret = new AccountIndexes();
                    List all = (List)results;
                    for (int outerIndex = 0; outerIndex < all.size(); ++outerIndex) {
                        List list = (List)all.get(outerIndex);
                        for (int innerIndex = 0; innerIndex < list.size(); ++innerIndex) {
                            Object accountId = list.get(innerIndex);
                            int index = outerIndex * AccountIndex.ENUMSET_SIZE.intValue() + innerIndex;
                            ret.put(accountId.toString(), new AccountIndex(index));
                        }
                    }
                    return Promise.value((Object)ret);
                });
            }
        };
    }

    public static Types.DeriveRealFunction idToIndex(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Object accountId = args[0];
                return AccountFunctions.indexes(api).call(new Object[0]).then(result -> {
                    AccountIndexes indexes = (AccountIndexes)result;
                    if (indexes == null) {
                        return Promise.value(null);
                    }
                    return Promise.value((Object)((AccountIndex)indexes.get(accountId.toString())));
                });
            }
        };
    }

    public static Types.DeriveRealFunction idAndIndex(final Types.ApiInterfacePromise api) {
        return new Types.DeriveRealFunction(){

            @Override
            public Promise call(Object ... args) {
                Object address = args[0];
                try {
                    byte[] decoded;
                    byte[] byArray = decoded = Utils.isU8a(address) ? Utils.u8aToU8a(address) : AddressCodec.decodeAddress(address.toString());
                    if (decoded.length == 32) {
                        AccountId accountId = new AccountId(decoded);
                        return AccountFunctions.idToIndex(api).call(accountId).then(result -> {
                            AccountIdAndIndex accountIdAndIndex = new AccountIdAndIndex(accountId, (AccountIndex)result);
                            return Promise.value((Object)accountIdAndIndex);
                        });
                    }
                    AccountIndex accountIndex = new AccountIndex((Object)decoded);
                    return AccountFunctions.indexToId(api).call(accountIndex).then(result -> {
                        AccountIdAndIndex accountIdAndIndex = new AccountIdAndIndex((AccountId)result, accountIndex);
                        return Promise.value((Object)accountIdAndIndex);
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Promise.value((Object)new AccountIdAndIndex(null, null));
                }
            }
        };
    }

    public static class AccountIdAndIndex {
        public AccountId accountId;
        public AccountIndex accountIndex;

        public AccountIdAndIndex(AccountId accountId, AccountIndex accountIndex) {
            this.accountId = accountId;
            this.accountIndex = accountIndex;
        }
    }

    public static class AccountIndexes
    extends LinkedHashMap<String, AccountIndex> {
    }
}

