/*
 * Decompiled with CFR 0.152.
 */
package org.polkadot.api.derive;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.polkadot.api.Types;
import org.polkadot.api.derive.Types;
import org.polkadot.api.derive.accounts.AccountFunctions;
import org.polkadot.api.derive.balances.BalancesFunctions;
import org.polkadot.api.derive.chain.ChainFunctions;
import org.polkadot.api.derive.democracy.DemocracyFunctions;
import org.polkadot.api.derive.session.SessionFunctions;
import org.polkadot.api.derive.staking.StakingFunctions;
import org.polkadot.direct.IFunction;
import org.polkadot.direct.IModule;
import org.polkadot.direct.ISection;

public class Index {
    public static DeriveCustom functions = new DeriveCustom();

    static Derive injectFunctions(Types.ApiInterfacePromise api, Derive derive, DeriveCustom functions) {
        if (functions == null) {
            return derive;
        }
        for (String sectionName : functions.sectionNames()) {
            DeriveCustomSection section = functions.section(sectionName);
            DeriveRealSection result = derive.section(sectionName);
            for (String methodName : section.functionNames()) {
                result.addFunction(methodName, ((DeriveCustomMethod)section.function(methodName)).apply(api));
            }
        }
        return derive;
    }

    public static Derive decorateDerive(Types.ApiInterfacePromise api, DeriveCustom custom) {
        Derive derive = new Derive();
        Index.injectFunctions(api, derive, functions);
        Index.injectFunctions(api, derive, custom);
        return derive;
    }

    static {
        functions.addSection("accounts", new DeriveCustomSection());
        functions.section("accounts").addFunction("idAndIndex", AccountFunctions::idAndIndex);
        functions.section("accounts").addFunction("idToIndex", AccountFunctions::idToIndex);
        functions.section("accounts").addFunction("indexToId", AccountFunctions::indexToId);
        functions.section("accounts").addFunction("indexes", AccountFunctions::indexes);
        functions.addSection("balances", new DeriveCustomSection());
        functions.section("balances").addFunction("fees", BalancesFunctions::fees);
        functions.section("balances").addFunction("validatingBalance", BalancesFunctions::validatingBalance);
        functions.section("balances").addFunction("validatingBalances", BalancesFunctions::validatingBalances);
        functions.section("balances").addFunction("votingBalance", BalancesFunctions::votingBalance);
        functions.section("balances").addFunction("votingBalances", BalancesFunctions::votingBalances);
        functions.section("balances").addFunction("votingBalancesNominatorsFor", BalancesFunctions::votingBalancesNominatorsFor);
        functions.addSection("chain", new DeriveCustomSection());
        functions.section("chain").addFunction("bestNumber", ChainFunctions::bestNumber);
        functions.section("chain").addFunction("bestNumberFinalized", ChainFunctions::bestNumberFinalized);
        functions.section("chain").addFunction("bestNumberLag", ChainFunctions::bestNumberLag);
        functions.section("chain").addFunction("getHeader", ChainFunctions::getHeader);
        functions.section("chain").addFunction("subscribeNewHead", ChainFunctions::subscribeNewHead);
        functions.addSection("democracy", new DeriveCustomSection());
        functions.section("democracy").addFunction("referendumInfos", DemocracyFunctions::referendumInfos);
        functions.section("democracy").addFunction("referendums", DemocracyFunctions::referendums);
        functions.section("democracy").addFunction("referendumVotesFor", DemocracyFunctions::referendumVotesFor);
        functions.section("democracy").addFunction("votes", DemocracyFunctions::votes);
        functions.addSection("session", new DeriveCustomSection());
        functions.section("session").addFunction("eraLength", SessionFunctions::eraLength);
        functions.section("session").addFunction("eraProgress", SessionFunctions::eraProgress);
        functions.section("session").addFunction("sessionProgress", SessionFunctions::sessionProgress);
        functions.addSection("staking", new DeriveCustomSection());
        functions.section("staking").addFunction("controllers", StakingFunctions::controllers);
        functions.section("staking").addFunction("intentionsBalances", StakingFunctions::intentionsBalances);
    }

    public static class Derive
    extends DeriveReal {
        DeriveRealSection account;
        DeriveRealSection balances;
        DeriveRealSection chain;
        DeriveRealSection democracy;
        DeriveRealSection session;
        DeriveRealSection staking;

        public Derive() {
            this.addSection("accounts", new DeriveRealSection());
            this.addSection("balances", new DeriveRealSection());
            this.addSection("chain", new DeriveRealSection());
            this.addSection("democracy", new DeriveRealSection());
            this.addSection("session", new DeriveRealSection());
            this.addSection("staking", new DeriveRealSection());
            this.account = this.section("account");
            this.balances = this.section("balances");
            this.chain = this.section("chain");
            this.democracy = this.section("democracy");
            this.session = this.section("session");
            this.staking = this.section("staking");
        }
    }

    public static class DeriveReal
    implements IModule<DeriveRealSection> {
        Map<String, DeriveRealSection> sectionMap = Maps.newLinkedHashMap();

        @Override
        public DeriveRealSection section(String section) {
            return this.sectionMap.get(section);
        }

        @Override
        public Set<String> sectionNames() {
            return this.sectionMap.keySet();
        }

        @Override
        public void addSection(String sectionName, DeriveRealSection section) {
            this.sectionMap.put(sectionName, section);
        }
    }

    public static class DeriveRealSection
    extends ISection<Types.DeriveRealFunction> {
    }

    public static class DeriveCustom
    implements IModule<DeriveCustomSection> {
        Map<String, DeriveCustomSection> sectionMap = Maps.newLinkedHashMap();

        @Override
        public DeriveCustomSection section(String section) {
            return this.sectionMap.get(section);
        }

        @Override
        public Set<String> sectionNames() {
            return this.sectionMap.keySet();
        }

        @Override
        public void addSection(String sectionName, DeriveCustomSection section) {
            this.sectionMap.put(sectionName, section);
        }
    }

    public static class DeriveCustomSection
    extends ISection<DeriveCustomMethod> {
    }

    static interface DeriveCustomMethod
    extends IFunction {
        public Types.DeriveRealFunction apply(Types.ApiInterfacePromise var1);
    }
}

