/*
 * Decompiled with CFR 0.152.
 */
package com.cloudburo.evernote;

import com.cloudburo.evernote.MiddleManBlogGenerator;
import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Tag;
import com.evernote.thrift.TException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    NoteStoreClient noteStore;
    static final Logger logger = LoggerFactory.getLogger(MiddleManBlogGenerator.class);

    public Utility(NoteStoreClient cl) {
        this.noteStore = cl;
    }

    public void createTags() throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        this.createTag("clb-image-fixedpos");
        this.createTag("clb-image-nopull");
        this.createTag("clb-image-pull-right");
        this.createTag("clb-image-lightbox");
        this.createTag("clb-blog-images");
        this.createTag("clb-image-noborder");
    }

    public boolean hasBlogImages(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-blog-images"))) {
            logger.debug("clb-blog-images is set");
            return true;
        }
        return false;
    }

    public boolean hasFixedImagePosition(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-image-fixedpos"))) {
            logger.debug("clb-image-fixedpos is set");
            return true;
        }
        return false;
    }

    public boolean hasNoPullImage(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-image-nopull"))) {
            logger.debug("clb-image-nopull is set");
            return true;
        }
        return false;
    }

    public boolean hasPullRight(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-image-pull-right"))) {
            logger.debug("clb-image-pull-right is set");
            return true;
        }
        return false;
    }

    public boolean hasLightbox(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-image-lightbox"))) {
            logger.debug("clb-image-lightbox is set");
            return true;
        }
        return false;
    }

    public boolean hasLightboxTitle(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-image-lightbox-title"))) {
            logger.debug("clb-image-lightbox-title is set");
            return true;
        }
        return false;
    }

    public boolean hasNoBorder(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-image-noborder"))) {
            logger.debug("clb-image-no-border is set");
            return true;
        }
        return false;
    }

    public boolean hasProcessedFlag(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-processed"))) {
            logger.debug("clb-processed is set");
            return true;
        }
        return false;
    }

    public boolean hasDeleteFlag(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-delete"))) {
            logger.debug("clb-delete is set");
            return true;
        }
        return false;
    }

    public void unsetDeleteTag(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        if (note.getTagGuids() != null && note.getTagGuids().contains(this.getTagGuidForName("clb-delete"))) {
            List nl = note.getTagGuids();
            nl.remove(this.getTagGuidForName("clb-delete"));
            note.setTagGuids(nl);
            this.noteStore.updateNote(note);
        }
    }

    public void createTag(String name) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        this.getTagGuidForName(name);
    }

    public String getTagGuidForName(String tagName) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        List tagsl = this.noteStore.listTags();
        if (tagsl != null) {
            for (Tag tag : tagsl) {
                if (!tag.getName().equals(tagName)) continue;
                return tag.getGuid();
            }
        }
        Tag newTag = new Tag();
        newTag.setName(tagName);
        Tag crTag = this.noteStore.createTag(newTag);
        logger.info("Created new tag '" + tagName + "' with id '" + crTag.getGuid() + "'");
        return crTag.getGuid();
    }

    public void applyTagToNote(Note note, String tagName) throws Exception {
        String tagid = this.getTagGuidForName(tagName);
        if (note.getTagGuids() == null) {
            logger.info("Adding tag: " + tagName);
            note.addToTagNames(tagName);
            this.noteStore.updateNote(note);
        } else if (!note.getTagGuids().contains(tagid)) {
            logger.info("Adding1 tag: " + tagName);
            note.addToTagNames(tagName);
            this.noteStore.updateNote(note);
        }
    }
}

