/*
 * Decompiled with CFR 0.152.
 */
package com.cloudburo.evernote;

import com.cloudburo.evernote.BlogGenerator;
import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Resource;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OctopressBlogGenerator
extends BlogGenerator {
    static final Logger logger = LoggerFactory.getLogger(OctopressBlogGenerator.class);

    public OctopressBlogGenerator(String blogName, NoteStoreClient store, String targetDir, boolean moveNote, boolean followLink) {
        super(blogName, store, targetDir, moveNote, followLink);
    }

    @Override
    public String getPostFilePostfix() {
        return ".md";
    }

    private void generateOctopressMarkdownHeaderBlog(StringBuffer buff, String blogName, Note note, String fileName, String blogDateFull, StringBuffer logDescr) throws Exception {
        String tagCategoryPrefix = blogName + "-";
        logDescr.append("Creating Octopress Markdown File: " + fileName + "\n");
        logger.debug("Creating Octopress Markdown File: " + fileName);
        buff.append("---\n");
        buff.append("layout: post\n");
        buff.append("title: \"" + note.getTitle().replace('\"', '\'') + "\"\n");
        buff.append("date: " + blogDateFull + "\n");
        buff.append("comments: true\n");
        buff.append("categories:\n");
        if (note.getTagGuids() != null) {
            Iterator it = note.getTagGuids().iterator();
            while (it.hasNext()) {
                String tagName = this.noteStore.getTag((String)it.next()).getName();
                if (!tagName.startsWith(tagCategoryPrefix)) continue;
                buff.append("- " + tagName.substring(tagCategoryPrefix.length()) + "\n");
            }
        }
        buff.append("---\n");
    }

    private void generateOctopressMarkdownHeaderDocument(StringBuffer buff, String blogName, Note note, String fileName, String blogDateFull, StringBuffer logDescr) throws Exception {
        String tagCategoryPrefix = blogName + "-";
        logDescr.append("Creating Octopress Markdown File: " + fileName + "\n");
        logger.debug("Creating Octopress Markdown File: " + fileName);
        buff.append("---\n");
        buff.append("layout: page \n");
        buff.append("title: \"" + note.getTitle().replace('\"', '\'') + "\"\n");
        buff.append("comments: false\n");
        buff.append("sharing: false\n");
        buff.append("footer: true\n");
        buff.append("categories:\n");
        if (note.getTagGuids() != null) {
            Iterator it = note.getTagGuids().iterator();
            while (it.hasNext()) {
                String tagName = this.noteStore.getTag((String)it.next()).getName();
                if (!tagName.startsWith(tagCategoryPrefix)) continue;
                buff.append("- " + tagName.substring(tagCategoryPrefix.length()) + "\n");
            }
        }
        buff.append("---\n");
    }

    public void generateNewsFile(Note note, String fileName, String blogDateFull, String doneGID, StringBuffer logDescr, int skipped) throws Exception {
        String sourceURL = note.getAttributes().getSourceURL();
        StringBuffer buff = new StringBuffer();
        String fileName1 = fileName + ".markdown";
        this.generateOctopressMarkdownHeaderBlog(buff, this.blogName, note, fileName1, blogDateFull, logDescr);
        Note fullNote = this.noteStore.getNote(note.getGuid(), true, false, false, false);
        logger.debug(fullNote.getContent());
        Document doc = Jsoup.parse((String)fullNote.getContent());
        Iterator boldsIt = doc.select("b").iterator();
        if (boldsIt.hasNext()) {
            while (boldsIt.hasNext()) {
                Element elem = (Element)boldsIt.next();
                buff.append(elem.text() + "\n");
            }
            if (sourceURL != null) {
                buff.append("\n[Link](" + sourceURL + ")");
            }
            logger.debug("CONTENT:\n" + buff.toString());
            File fi = new File(this.targetDir + fileName1);
            OctopressBlogGenerator.writeToFile(fi, Charset.forName("UTF-8"), buff.toString());
            if (this.moveNote) {
                note.setNotebookGuid(doneGID);
                this.noteStore.updateNote(note);
                logger.debug("Moved processed Note");
            }
        } else {
            logger.warn("Note '" + note.getTitle() + "' has no marked text, don't take it over");
            ++skipped;
        }
    }

    @Override
    public void generateCurationFile(Note note, String fileName, String blogDateFull, String doneGID, StringBuffer logDescr, int skipped, boolean curationType) throws Exception {
        StringBuffer buff = new StringBuffer();
        String fileName1 = fileName + ".markdown";
        String targetDirectory = this.targetDir;
        boolean docPage = false;
        String imageDirectory = this.targetDir + "../img/";
        if (note.getTagGuids() != null) {
            Iterator it = note.getTagGuids().iterator();
            while (it.hasNext()) {
                String string = this.noteStore.getTag((String)it.next()).getName();
            }
        }
        if (docPage) {
            this.generateOctopressMarkdownHeaderDocument(buff, this.blogName, note, fileName1, blogDateFull, logDescr);
        } else {
            this.generateOctopressMarkdownHeaderBlog(buff, this.blogName, note, fileName1, blogDateFull, logDescr);
        }
        Vector<CallSite> mdPics = new Vector<CallSite>();
        Note fullNote = this.noteStore.getNote(note.getGuid(), true, false, false, false);
        if (fullNote.getResources() != null) {
            Iterator it = fullNote.getResources().iterator();
            Vector<Resource> picList = new Vector<Resource>();
            while (it.hasNext()) {
                Resource res = (Resource)it.next();
                String mime = res.getMime().split("/")[1];
                if (!mime.equals("gif") && !mime.equals("png") && !mime.equals("jpeg")) continue;
                picList.add(res);
            }
            int imgIndex = 0;
            int imgSize = 400;
            it = picList.iterator();
            String imgPos = "left";
            while (it.hasNext()) {
                Resource res = (Resource)it.next();
                String mime = res.getMime().split("/")[1];
                Resource resource = this.noteStore.getResource(res.getGuid(), true, false, true, false);
                String fiName = fileName + "-" + Integer.toString(imgIndex) + "." + mime;
                String fullFiName = imageDirectory + "/" + fiName;
                DataOutputStream os = new DataOutputStream(new FileOutputStream(fullFiName));
                os.write(resource.getData().getBody());
                os.close();
                BufferedImage img = ImageIO.read(new File(fullFiName));
                BufferedImage renderedImg = Scalr.resize((BufferedImage)img, (int)imgSize, (BufferedImageOp[])new BufferedImageOp[0]);
                ImageIO.write((RenderedImage)renderedImg, mime, new File(fullFiName));
                mdPics.add((CallSite)((Object)("{% img " + imgPos + " /img/" + fiName + " '" + note.getTitle() + "' %}")));
                imgPos = "";
                ++imgIndex;
            }
        }
        logger.debug(fullNote.getContent());
        Document doc = Jsoup.parse((String)fullNote.getContent());
        Iterator nodesIt = doc.select("en-note").iterator();
        if (nodesIt.hasNext()) {
            Element elem = (Element)nodesIt.next();
            String sourceURL = note.getAttributes().getSourceURL();
            if (sourceURL != null) {
                buff.append("\n[Link](" + sourceURL + ")");
            }
            if (mdPics.size() > 0) {
                buff.append((String)mdPics.get(0));
            }
            buff.append(this.cleanupHTML(elem.html()) + "\n");
            if (mdPics.size() > 1) {
                buff.append("<!--more-->");
                for (int i = 1; i < mdPics.size(); ++i) {
                    buff.append((String)mdPics.get(i));
                }
            }
            logger.debug("CONTENT:\n" + buff.toString());
            File fi = new File(targetDirectory + fileName1);
            OctopressBlogGenerator.writeToFile(fi, Charset.forName("UTF-8"), buff.toString());
            if (this.moveNote) {
                note.setNotebookGuid(doneGID);
                this.noteStore.updateNote(note);
                logger.debug("Moved processed Note");
            }
        } else {
            logger.warn("Note '" + note.getTitle() + "' has en-note, don't take it over, something wrong");
            ++skipped;
        }
    }
}

