/*
 * Decompiled with CFR 0.152.
 */
package com.cloudburo.evernote;

import com.cloudburo.evernote.BlogGenerator;
import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.type.Note;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiddleManBlogGenerator
extends BlogGenerator {
    static final Logger logger1 = LoggerFactory.getLogger(MiddleManBlogGenerator.class);
    static final String imageDir = "images";

    public MiddleManBlogGenerator(String blogName, NoteStoreClient store, String targetDir, boolean moveNote, boolean followLink) {
        super(blogName, store, targetDir, moveNote, followLink);
        this.imageDirectory = this.targetDir + "../images/";
    }

    @Override
    public String getPostFilePostfix() {
        return ".html.slim";
    }

    private void generateHeader(String guid, long updated, StringBuffer buff, String blogName, Note note, String fileName, String blogDateFull, StringBuffer logDescr, boolean docPage, String imgForHeader, String tbImgForHeader, String tbImg1ForHeader, String shortText, String middleText) throws Exception {
        String tagCategoryPrefix = blogName + "-";
        logDescr.append("Creating MiddleMan Slim File: " + fileName + "\n");
        logger1.debug("MiddleManBlogGenerator.generateHeader: Creating MiddleMan Slim File: " + fileName);
        buff.append("---\n");
        buff.append("guid: " + guid + "\n");
        buff.append("update: " + updated + "\n");
        if (docPage) {
            buff.append("title: \"" + note.getTitle().replace('\"', '\'') + "\"\n");
            buff.append("layout: simple");
        } else {
            buff.append("title: \"" + note.getTitle().replace('\"', '\'') + "\"\n");
            buff.append("date: " + blogDateFull + "\n");
            if (imgForHeader != null) {
                buff.append("picture: \"" + imgForHeader + "\"\n");
                buff.append("picture_thumbn: \"" + tbImgForHeader + "\"\n");
                buff.append("picture_thumbn1: \"" + tbImg1ForHeader + "\"\n");
            }
            buff.append("shortText: \"" + shortText + "\"\n");
            buff.append("middleText: \"" + middleText + "\"\n");
            buff.append("tags: ");
            if (note.getTagGuids() != null) {
                Iterator it = note.getTagGuids().iterator();
                while (it.hasNext()) {
                    String tagName = this.noteStore.getTag((String)it.next()).getName();
                    if (!tagName.startsWith(tagCategoryPrefix)) continue;
                    buff.append(tagName.substring(tagCategoryPrefix.length()));
                    if (!it.hasNext()) continue;
                    buff.append(",");
                }
            }
        }
        buff.append("\n---\n");
    }

    public void generateBlogImages(Note note, String doneGID) throws Exception {
        logger.debug("MiddleManBlogGenerator.generateBlogImages: BlogImages Note detected");
        String noteGuid = note.getGuid();
        long noteUpdated = note.getUpdated();
        Note fullNote = this.noteStore.getNote(noteGuid, true, false, false, false);
        Document doc = Jsoup.parse((String)fullNote.getContent());
        doc.outputSettings().prettyPrint(false);
        String htmlDoc = this.processNote(doc, "    ", fullNote.getGuid(), note);
        logger.debug("MiddleManBlogGenerator.generateBlogImages: Extracted Note: " + htmlDoc);
        String[] splits = htmlDoc.split("img1_");
        StringBuffer bgImgBuf = new StringBuffer();
        boolean found = false;
        int pos = 0;
        for (int i = 0; i < splits.length; ++i) {
            logger.debug("MiddleManBlogGenerator.generateBlogImages: Split Check " + i + ":" + splits[i]);
            if (!Character.isLetterOrDigit(splits[i].charAt(0))) continue;
            found = true;
            String[] lineSplit = splits[i].split(" ");
            bgImgBuf.append("backgroundImage_" + ++pos + ": /images/" + lineSplit[0].trim() + "\n");
        }
        if (!found) {
            bgImgBuf.append("backgroundImage_1:");
        }
        logger.debug("MiddleManBlogGenerator.generateBlogImages: Got image note: " + bgImgBuf);
        File fi = new File(this.targetDir + "../../data/blogImages.yml");
        MiddleManBlogGenerator.writeToFile(fi, Charset.forName("UTF-8"), bgImgBuf.toString());
        if (this.moveNote) {
            note.setNotebookGuid(doneGID);
            this.noteStore.updateNote(note);
            logger1.debug("MiddleManBlogGenerator.generateBlogImages: Moved processed Note");
        }
    }

    @Override
    public void generateCurationFile(Note note, String fileName, String blogDateFull, String doneGID, StringBuffer logDescr, int skipped, boolean curationType) throws Exception {
        StringBuffer curatedNote = new StringBuffer();
        String fileName1 = fileName + ".html.slim";
        Object targetDirectory = this.targetDir;
        String space3 = "      ";
        String space2 = "    ";
        String space1 = "  ";
        String imgForHeader = null;
        String tbImgForHeader = null;
        String tbImg1ForHeader = null;
        String shortText = "";
        String middleText = "";
        if (this.hasBlogImages(note)) {
            this.generateBlogImages(note, doneGID);
            return;
        }
        boolean docPage = false;
        if (note.getTagGuids() != null) {
            Iterator it = note.getTagGuids().iterator();
            while (it.hasNext()) {
                String tagName = this.noteStore.getTag((String)it.next()).getName();
                if (!this.isMenuPage(tagName)) continue;
                docPage = true;
                curationType = true;
                fileName1 = this.getMenuFileName(tagName) + ".html.slim";
                if (!this.targetDir.endsWith("/")) {
                    this.targetDir = this.targetDir + "/";
                }
                targetDirectory = this.targetDir + "../";
            }
        }
        String noteGuid = note.getGuid();
        long noteUpdated = note.getUpdated();
        Note fullNote = this.noteStore.getNote(noteGuid, true, false, false, false);
        logger.debug("MiddleManBlogGenerator.generateCurationFile: Full Evernote Note: " + fullNote.getContent());
        Document doc = Jsoup.parse((String)fullNote.getContent());
        doc.outputSettings().prettyPrint(false);
        Object allText = doc.select("en-note").text();
        allText = ((String)allText).replaceAll("\\s+", " ");
        allText = ((String)allText).replaceAll("\"", "'");
        Object htmlDoc = "";
        logger.debug("MiddleManBlogGenerator.generateCurationFile: Extracted Note: " + (String)allText);
        if (!curationType) {
            StringBuffer buff = new StringBuffer();
            Iterator boldsIt = doc.select("b").iterator();
            if (!boldsIt.hasNext()) {
                boldsIt = doc.select("strong").iterator();
            }
            if (!boldsIt.hasNext()) {
                boldsIt = doc.select("[style*=font-weight: bold]").iterator();
            }
            if (!boldsIt.hasNext()) {
                logger.warn("MiddleManBlogGenerator.generateCurationFile: News Note without bold content");
            }
            if (boldsIt.hasNext()) {
                allText = "";
                while (boldsIt.hasNext()) {
                    Element elem = (Element)boldsIt.next();
                    buff.append(space3 + elem.text() + "<br/>\n");
                    allText = (String)allText + elem.text();
                }
            }
            htmlDoc = buff.toString();
        } else {
            htmlDoc = this.processNote(doc, space3, fullNote.getGuid(), note);
        }
        int len = ((String)allText).length();
        if (len > 100) {
            len = 100;
        }
        shortText = ((String)allText).substring(0, len);
        len = ((String)allText).length();
        if (len > 250) {
            len = 250;
        }
        middleText = ((String)allText).substring(0, len);
        boolean firstImage = !this.hasFixedImagePosition(note);
        Object imgPos = "<img class='pull-left img-responsive article";
        if (this.hasPullRightImage(note)) {
            imgPos = "<img class='pull-right img-responsive article";
        } else if (this.hasNoPullImage(note)) {
            imgPos = "<img class='article ";
        }
        imgPos = this.hasNoBorderImage(note) ? (String)imgPos + "' style=\"max-width:100%\" " : (String)imgPos + " img-thumbnail' ";
        if (((String)htmlDoc).equals("")) {
            ++skipped;
        } else {
            String sourceURL = note.getAttributes().getSourceURL();
            if (sourceURL != null) {
                htmlDoc = this.followLink ? (String)htmlDoc + space3 + "[Link](" + sourceURL + ")" : (String)htmlDoc + space3 + "<a href='" + sourceURL + "' rel='nofollow'>Link</a>";
            }
            String[] splits = ((String)htmlDoc).split("img1_");
            StringBuffer articleContent = new StringBuffer();
            if (splits.length == 0) {
                articleContent.append(space1 + "div.article\n");
                articleContent.append(space2 + "markdown:\n");
                articleContent.append((String)htmlDoc);
            } else {
                boolean firstImageForHeader = true;
                for (int i = 0; i < splits.length; ++i) {
                    String[] endOfLineSplit;
                    if (!Character.isLetterOrDigit(splits[i].charAt(0))) {
                        articleContent.append(space1 + "div.article\n");
                        articleContent.append(space2 + "markdown:\n");
                        articleContent.append(space3 + "<span/>");
                        articleContent.append(splits[i]);
                        continue;
                    }
                    String[] lineSplit = splits[i].split(" ");
                    String prefixSpace = space3 + "   ";
                    String str = splits[i].toString();
                    int pos = 0;
                    while (str.charAt(pos) == ' ') {
                        prefixSpace = prefixSpace + " ";
                        ++pos;
                    }
                    if (firstImage) {
                        String tmp = space1 + "markdown:\n";
                        tmp = tmp + space2 + (String)imgPos + "src='/images/" + lineSplit[0].trim() + "'>\n";
                        tmp = tmp + "\n" + articleContent.toString();
                        articleContent = new StringBuffer(tmp);
                        firstImage = false;
                    } else if (this.hasLightBox(note)) {
                        articleContent.append("\n" + prefixSpace + "<a data-toggle='lightbox' href='/images/" + lineSplit[0].trim() + "'/>");
                        articleContent.append("\n  " + prefixSpace + (String)imgPos + "src='/images/tb-" + lineSplit[0].trim() + "'>");
                    } else {
                        articleContent.append("\n" + prefixSpace + (String)imgPos + "src='/images/" + lineSplit[0].trim() + "'>");
                    }
                    if (firstImageForHeader) {
                        firstImageForHeader = false;
                        imgForHeader = "/images/" + lineSplit[0].trim();
                        tbImgForHeader = "/images/tb-" + lineSplit[0].trim();
                        tbImg1ForHeader = "/images/tb1-" + lineSplit[0].trim();
                    }
                    if ((endOfLineSplit = splits[i].split(lineSplit[0])).length != 2) continue;
                    articleContent.append("\n" + space1 + "div.article\n");
                    articleContent.append(space2 + "markdown:\n");
                    articleContent.append(space3 + "<span/>");
                    articleContent.append(endOfLineSplit[1]);
                }
            }
            this.generateHeader(noteGuid, noteUpdated, curatedNote, this.blogName, note, fileName1, blogDateFull, logDescr, docPage, imgForHeader, tbImgForHeader, tbImg1ForHeader, shortText, middleText);
            curatedNote.append("div.row\n");
            curatedNote.append(articleContent.toString());
        }
        String cleanedNote = curatedNote.toString().replaceAll("&nbsp;", " ");
        logger1.debug("MiddleManBlogGenerator.generateCuration curatedNote:\n" + curatedNote.toString());
        File fi = new File((String)targetDirectory + fileName1);
        MiddleManBlogGenerator.writeToFile(fi, Charset.forName("UTF-8"), cleanedNote);
        if (this.moveNote) {
            note.setNotebookGuid(doneGID);
            this.noteStore.updateNote(note);
            logger1.debug("MiddleManBlogGenerator.generateCurationFile.Moved processed Note");
        }
    }
}

