/*
 * Decompiled with CFR 0.152.
 */
package com.cloudburo.evernote;

import com.evernote.auth.EvernoteAuth;
import com.evernote.auth.EvernoteService;
import com.evernote.clients.ClientFactory;
import com.evernote.clients.NoteStoreClient;
import com.evernote.clients.UserStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.Notebook;
import com.evernote.thrift.TException;
import com.evernote.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvernoteInfo {
    private UserStoreClient userStore;
    private NoteStoreClient noteStore;
    static final Logger logger = LoggerFactory.getLogger(EvernoteInfo.class);

    public EvernoteInfo(String token, Boolean productionEnv) throws EDAMSystemException, EDAMUserException, TTransportException, TException, EDAMNotFoundException {
        EvernoteAuth evernoteAuth = productionEnv != false ? new EvernoteAuth(EvernoteService.PRODUCTION, token) : new EvernoteAuth(EvernoteService.SANDBOX, token);
        ClientFactory factory = new ClientFactory(evernoteAuth);
        this.userStore = factory.createUserStoreClient();
        this.noteStore = factory.createNoteStoreClient();
        boolean versionOk = this.userStore.checkVersion("Evernote EDAMDemo (Java)", (short)1, (short)25);
        if (!versionOk) {
            logger.error("Incompatible Evernote client protocol version");
            System.exit(1);
        }
    }

    public int getUserId() throws Exception {
        return this.userStore.getUser().getId();
    }

    public String getUserEmail() throws Exception {
        return this.userStore.getUser().getEmail();
    }

    public String getUserName() throws Exception {
        return this.userStore.getUser().getUsername();
    }

    public String getName() throws Exception {
        return this.userStore.getUser().getName();
    }

    public String getNotebookName(String notebookGuid) throws Exception {
        Notebook nb = this.noteStore.getNotebook(notebookGuid);
        return nb.getName();
    }

    public void revokeLongSession() throws Exception {
        this.userStore.revokeLongSession();
    }
}

