/*
 * Decompiled with CFR 0.152.
 */
package com.cloudburo.evernote;

import com.cloudburo.evernote.BlogGenerator;
import com.cloudburo.evernote.MiddleManBlogGenerator;
import com.cloudburo.evernote.Utility;
import com.cloudburo.grab.webcontent.Grabber;
import com.cloudburo.grab.webcontent.GrabberRecord;
import com.evernote.auth.EvernoteAuth;
import com.evernote.auth.EvernoteService;
import com.evernote.clients.ClientFactory;
import com.evernote.clients.NoteStoreClient;
import com.evernote.clients.UserStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.NoteAttributes;
import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Tag;
import com.evernote.thrift.TException;
import com.evernote.thrift.transport.TTransportException;
import com.github.slugify.Slugify;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvernoteBlogPostGenerator {
    static final Logger logger = LoggerFactory.getLogger(EvernoteBlogPostGenerator.class);
    private UserStoreClient userStore;
    private NoteStoreClient noteStore;
    private String blogName;
    private String targetDir;
    private Utility utility;
    private boolean serviceNews;
    private boolean serviceCuration;
    private static boolean moveNote = true;
    private boolean followLink;
    private static final String N_AUTOMATIC_GRAB = "-A-Fetch";
    private static final String N_PREPARE_BLOG = "-B-Prepare";
    private static final String N_NEWS_GEN = "-D-NewsGen";
    private static final String N_CURATION_GEN = "-E-CurateGen";
    private static final String N_ARCHIVE = "-Z-Archive";
    private static final int MAX_SEARCH_RESULTS = 3;

    public EvernoteBlogPostGenerator(String token, Boolean productionEnv, String blogName, String targetDir, Boolean moveN, boolean serviceCuration, boolean serviceNews, boolean followLink) throws EDAMSystemException, EDAMUserException, TTransportException, TException, EDAMNotFoundException, Exception {
        this.blogName = blogName;
        this.targetDir = targetDir;
        this.serviceNews = serviceNews;
        this.serviceCuration = serviceCuration;
        this.followLink = followLink;
        moveNote = moveN;
        EvernoteAuth evernoteAuth = productionEnv != false ? new EvernoteAuth(EvernoteService.PRODUCTION, token) : new EvernoteAuth(EvernoteService.SANDBOX, token);
        ClientFactory factory = new ClientFactory(evernoteAuth);
        this.userStore = factory.createUserStoreClient();
        boolean versionOk = this.userStore.checkVersion("Evernote EDAMDemo (Java)", (short)1, (short)25);
        if (!versionOk) {
            logger.error("Incompatible Evernote client protocol version");
            System.exit(1);
        }
        this.noteStore = factory.createNoteStoreClient();
        this.utility = new Utility(this.noteStore);
        this.utility.createTags();
        if (serviceCuration) {
            this.checkAndFixNotebookStructure(true);
        }
        if (serviceNews) {
            this.checkAndFixNotebookStructure(false);
        }
    }

    public void checkAndCreateTaggedNotes(String[] tags, String[] title) throws Exception {
        List tagsl = this.noteStore.listTags();
        for (int i = 0; i < tags.length; ++i) {
            String taguid = null;
            for (Tag tag : tagsl) {
                if (!tag.getName().equals(tags[i])) continue;
                taguid = tag.getGuid();
                break;
            }
            boolean createNote = false;
            ArrayList<String> tidList = new ArrayList<String>();
            if (taguid == null) {
                Tag newTag = new Tag();
                newTag.setName(tags[i]);
                taguid = this.noteStore.createTag(newTag).getGuid();
                tidList.add(taguid);
                createNote = true;
            } else {
                NoteFilter filter = new NoteFilter();
                tidList.add(taguid);
                filter.setTagGuids(tidList);
                NoteList noteList = this.noteStore.findNotes(filter, 0, 1);
                if (noteList.getNotes().size() == 0) {
                    createNote = true;
                }
            }
            if (!createNote) continue;
            logger.info("Creating new note for tag '" + tags[i] + "' and title '" + title[i] + "'");
            this.checkAndFixNotebookStructure(true);
            Note note = new Note();
            note.setTitle(title[i]);
            note.setTagGuids(tidList);
            note.setNotebookGuid(this.getNoteBook(N_PREPARE_BLOG).getGuid());
            String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\"><en-note><span style=\"color:green;\">Add your content</span><br/><span style=\"color:red;\">F\u00c3\u00bcgen sie ihren Text ein</span><br/></en-note>";
            note.setContent(content);
            this.noteStore.createNote(note);
        }
    }

    private Notebook getNoteBook(String postFix) throws Exception {
        String blogName = "blog-" + this.blogName + postFix;
        logger.debug("Get Notebook " + blogName);
        List notebooks = this.noteStore.listNotebooks();
        for (Notebook notebook : notebooks) {
            if (!notebook.getName().equals(blogName)) continue;
            return notebook;
        }
        throw new Exception("Couldn't find Notebook " + blogName);
    }

    protected Hashtable<String, String> checkAndFixNotebookStructure(boolean curationBlogType) throws Exception {
        Notebook nb;
        List notebooks = this.noteStore.listNotebooks();
        String doneGID = null;
        String inGID = null;
        String prepGID = null;
        String autoGID = null;
        Object queueGID = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (Notebook notebook : notebooks) {
            if (notebook.getName().equals("blog-" + this.blogName + N_ARCHIVE)) {
                doneGID = notebook.getGuid();
                table.put(N_ARCHIVE, doneGID);
                continue;
            }
            if (notebook.getName().equals("blog-" + this.blogName + N_PREPARE_BLOG)) {
                prepGID = notebook.getGuid();
                table.put(N_PREPARE_BLOG, prepGID);
                continue;
            }
            if (notebook.getName().equals("blog-" + this.blogName + N_CURATION_GEN) && curationBlogType) {
                inGID = notebook.getGuid();
                table.put(N_CURATION_GEN, inGID);
                continue;
            }
            if (notebook.getName().equals("blog-" + this.blogName + N_NEWS_GEN) && !curationBlogType) {
                inGID = notebook.getGuid();
                table.put(N_NEWS_GEN, inGID);
                continue;
            }
            if (!notebook.getName().equals("blog-" + this.blogName + N_AUTOMATIC_GRAB) || curationBlogType) continue;
            autoGID = notebook.getGuid();
            table.put(N_AUTOMATIC_GRAB, autoGID);
        }
        if (doneGID == null) {
            nb = new Notebook();
            nb.setName("blog-" + this.blogName + N_ARCHIVE);
            table.put(N_ARCHIVE, this.noteStore.createNotebook(nb).getGuid());
        }
        if (prepGID == null) {
            nb = new Notebook();
            nb.setName("blog-" + this.blogName + N_PREPARE_BLOG);
            table.put(N_PREPARE_BLOG, this.noteStore.createNotebook(nb).getGuid());
        }
        if (curationBlogType) {
            if (inGID == null) {
                nb = new Notebook();
                nb.setName("blog-" + this.blogName + N_CURATION_GEN);
                table.put(N_CURATION_GEN, this.noteStore.createNotebook(nb).getGuid());
            }
        } else {
            if (inGID == null) {
                nb = new Notebook();
                nb.setName("blog-" + this.blogName + N_NEWS_GEN);
                table.put(N_NEWS_GEN, this.noteStore.createNotebook(nb).getGuid());
            }
            if (autoGID == null) {
                nb = new Notebook();
                nb.setName("blog-" + this.blogName + N_AUTOMATIC_GRAB);
                table.put(N_AUTOMATIC_GRAB, this.noteStore.createNotebook(nb).getGuid());
            }
        }
        return table;
    }

    public void fetchHTMLContent() throws Exception {
        String blogName = "blog-" + this.blogName;
        logger.debug("Fetch News HTML pages for " + blogName);
        Hashtable<String, String> table = this.checkAndFixNotebookStructure(false);
        Notebook notebook = this.noteStore.getNotebook(table.get(N_AUTOMATIC_GRAB));
        NoteFilter filter = new NoteFilter();
        filter.setNotebookGuid(notebook.getGuid());
        filter.setOrder(NoteSortOrder.CREATED.getValue());
        filter.setAscending(true);
        NoteList noteList = this.noteStore.findNotes(filter, 0, 3);
        List notes = noteList.getNotes();
        long startTime = System.currentTimeMillis();
        Grabber grabber = new Grabber();
        for (Note note : notes) {
            String sourceURL = note.getAttributes().getSourceURL();
            Note fullNote = this.noteStore.getNote(note.getGuid(), true, false, false, false);
            try {
                GrabberRecord rec = grabber.extractArticle(sourceURL, true);
                rec.content = StringEscapeUtils.escapeHtml((String)rec.content);
                String article = "<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\"><en-note>" + rec.content + "</en-note>";
                logger.debug("Fetched article: " + article);
                fullNote.setContent(article);
                NoteAttributes attr = fullNote.getAttributes();
                logger.debug("url fetched: " + rec.url.toExternalForm());
                attr.setSourceURL(rec.url.toExternalForm());
                fullNote.setAttributes(attr);
                fullNote.setNotebookGuid(table.get(N_PREPARE_BLOG));
                this.noteStore.updateNote(fullNote);
                logger.debug("Updated note; " + note.getTitle());
            }
            catch (Exception ex1) {
                logger.warn("Grabbing of htlm record failed, going to move it: " + ex1.getMessage(), (Throwable)ex1);
                try {
                    note.setNotebookGuid(table.get(N_PREPARE_BLOG));
                    this.noteStore.updateNote(note);
                }
                catch (Exception ex2) {
                    logger.error("Move of record failed- go on: " + ex2.getMessage(), (Throwable)ex2);
                }
            }
        }
        long execTime = System.currentTimeMillis() - startTime;
        logger.info("@" + blogName + " fetched Articles completed in '" + execTime + "' ms");
        Thread.sleep(1000L);
    }

    public int generateBlogEntry(boolean curationBlogType, int maxNews, boolean cleanupStep) throws Exception {
        String blogName = "blog-" + this.blogName;
        MiddleManBlogGenerator generator = new MiddleManBlogGenerator(this.blogName, this.noteStore, this.targetDir, moveNote, this.followLink);
        Hashtable<String, String> table = this.checkAndFixNotebookStructure(curationBlogType);
        Notebook notebook = null;
        notebook = curationBlogType ? this.noteStore.getNotebook(table.get(N_CURATION_GEN)) : this.noteStore.getNotebook(table.get(N_NEWS_GEN));
        NoteFilter filter = new NoteFilter();
        filter.setNotebookGuid(notebook.getGuid());
        filter.setOrder(NoteSortOrder.CREATED.getValue());
        filter.setAscending(true);
        NoteList noteList = null;
        if (cleanupStep) {
            ArrayList<String> tagsGuids = new ArrayList<String>();
            tagsGuids.add(this.utility.getTagGuidForName("clb-processed"));
            filter.setTagGuids(tagsGuids);
            filter.setTagGuidsIsSet(true);
            noteList = this.noteStore.findNotes(filter, 0, maxNews);
            tagsGuids = new ArrayList();
            tagsGuids.add(this.utility.getTagGuidForName("clb-delete"));
            filter.setTagGuids(tagsGuids);
            NoteList noteList1 = this.noteStore.findNotes(filter, 0, maxNews);
            Iterator it = noteList1.getNotesIterator();
            while (it.hasNext()) {
                Note nt = (Note)it.next();
                if (noteList.getNotes().contains(nt)) continue;
                noteList.addToNotes((Note)it.next());
            }
        } else {
            noteList = this.noteStore.findNotes(filter, 0, maxNews);
        }
        List notes = noteList.getNotes();
        long startTime = System.currentTimeMillis();
        int skipped = 0;
        int generate = 0;
        int futurePost = 0;
        int deletePost = 0;
        StringBuffer logDescr = new StringBuffer();
        for (Note note : notes) {
            logger.info("Processing html.slim for '" + note.getTitle() + "'");
            String fileName = null;
            String blogDateFull = null;
            Date bloggingDate = new Date();
            boolean processFlag = this.utility.hasProcessedFlag(note);
            if (!processFlag && bloggingDate.before(new Date(note.getUpdated()))) {
                ++futurePost;
                continue;
            }
            if (!processFlag) {
                note.setCreated(bloggingDate.getTime());
            } else {
                bloggingDate = new Date(note.getCreated());
            }
            String title = new Slugify().slugify(note.getTitle());
            if (title.length() > 80) {
                title = title.substring(0, 80);
            }
            fileName = new SimpleDateFormat("yyyy-MM-dd").format(bloggingDate) + "-" + title;
            blogDateFull = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(bloggingDate);
            if (this.utility.hasDeleteFlag(note)) {
                if (this.deleteEntry(fileName, generator)) {
                    ++deletePost;
                    ++generate;
                    this.utility.unsetDeleteTag(note);
                }
                if (!moveNote) continue;
                note.setNotebookGuid(table.get(N_ARCHIVE));
                this.noteStore.updateNote(note);
                logger.debug("Moved deleted processed Note");
                continue;
            }
            ((BlogGenerator)generator).generateCurationFile(note, fileName, blogDateFull, table.get(N_ARCHIVE), logDescr, skipped, curationBlogType);
            ++generate;
            this.utility.applyTagToNote(note, "clb-processed");
        }
        long execTime = System.currentTimeMillis() - startTime;
        String msg = "";
        msg = curationBlogType ? "Curation" : "News";
        int gen = generate - deletePost;
        logger.info("@" + blogName + " - " + msg + " Entries Generation in '" + execTime + "' ms:' gen(" + gen + "), fut(" + futurePost + "), del(" + deletePost + ") nok(" + skipped + ")");
        Thread.sleep(1000L);
        return generate;
    }

    private boolean deleteEntry(String fileName, BlogGenerator generator) {
        String target = this.targetDir + "/" + fileName + generator.getPostFilePostfix();
        File fi = new File(target);
        if (fi.delete()) {
            logger.info("Deleted File " + target);
            return true;
        }
        logger.warn("Deleting of File failed " + target);
        return false;
    }
}

