/*
 * Decompiled with CFR 0.152.
 */
package com.cloudburo.evernote;

import com.cloudburo.evernote.Utility;
import com.cloudburo.evernote.VideoHelper;
import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Resource;
import com.evernote.thrift.TException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlogGenerator {
    static final Logger logger = LoggerFactory.getLogger(BlogGenerator.class);
    private static final String T_MENU = "clb-menu";
    private static final String T_FOOTER = "clb-footer";
    private static final String T_INDEX = "clb-index";
    private static final String T_MENU_PREFIX = "clb-";
    protected String imageDirectory;
    protected String blogName;
    protected String targetDir;
    protected NoteStoreClient noteStore;
    protected Utility utility;
    protected boolean moveNote;
    protected boolean followLink;

    public BlogGenerator(String blogName, NoteStoreClient store, String targetDir, boolean moveNote, boolean followLink) {
        this.blogName = blogName;
        this.noteStore = store;
        this.targetDir = targetDir;
        this.moveNote = moveNote;
        this.followLink = followLink;
        this.utility = new Utility(store);
    }

    public abstract void generateCurationFile(Note var1, String var2, String var3, String var4, StringBuffer var5, int var6, boolean var7) throws Exception;

    public abstract String getPostFilePostfix();

    public boolean isMenuPage(String tagName) {
        return tagName.startsWith(T_MENU) || tagName.startsWith(T_INDEX) || tagName.startsWith(T_FOOTER);
    }

    public String getMenuFileName(String tagName) {
        return tagName.substring(T_MENU_PREFIX.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeToFile(File file, Charset charset, String data) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try (Closeable stream = out;){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
            stream = writer;
            writer.write(data);
        }
    }

    protected int countWords(String input) {
        String[] words = input.split(" ");
        return words.length;
    }

    protected String cleanupStyleAttribute(Element doc) {
        for (Element e : doc.select("[style]")) {
            Attributes styleAtt = e.attributes();
            Attribute a = (Attribute)styleAtt.asList().get(0);
            if (!a.getKey().equals("style")) continue;
            String[] items = a.getValue().trim().split(";");
            String newValue = "";
            for (String item : items) {
                if (!item.contains("font-size:") && !item.contains("text-decoration:") && !item.contains("color:") && !item.contains("font-weight:") && !item.contains("font-style:") && !item.contains("text-align") && !item.contains("border") && !item.contains("padding") && !item.contains("margin") && !item.contains("table-layout") && !item.contains("font-family") && !item.contains("border-collapse") && !item.contains("min-width")) continue;
                logger.debug("Style Item takeover: " + item);
                newValue = newValue.concat(item).concat(";");
            }
            a.setValue(newValue);
        }
        return doc.html();
    }

    protected String cleanupHTML(String elem) {
        Whitelist list = Whitelist.simpleText();
        list.addTags(new String[]{"a", "b", "blockquote", "br", "cite", "code", "dd", "dl", "dt", "em", "i", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "u", "ul", "table", "td", "tr", "iframe", "font"});
        list.addAttributes("a", new String[]{"href"});
        list.addAttributes("blockquote", new String[]{"cite"});
        list.addAttributes("q", new String[]{"cite"});
        list.addAttributes("div", new String[]{"class"});
        list.addAttributes("iframe", new String[]{"class", "frameborder", "allowfullscreen", "src"});
        list.addAttributes("font", new String[]{"face"});
        list.addProtocols("a", "href", new String[]{"ftp", "http", "https", "mailto"});
        list.addProtocols("blockquote", "cite", new String[]{"http", "https"});
        list.addProtocols("cite", "cite", new String[]{"http", "https"});
        list.addTags(new String[]{"div"});
        list.addTags(new String[]{"img"});
        list.addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width", "text-align"});
        list.addProtocols("img", "src", new String[]{"http", "https"});
        if (!this.followLink) {
            list.addEnforcedAttribute("a", "rel", "nofollow");
        }
        list.addAttributes(":all", new String[]{"style"});
        elem = VideoHelper.processVideoTags(elem);
        logger.debug("Jsoup.before: " + elem);
        String doc = Jsoup.clean((String)elem, (Whitelist)list);
        logger.debug("Jsoup.clean 2: " + doc);
        Document xmlDoc = Jsoup.parse((String)doc);
        doc = this.cleanupStyleAttribute((Element)xmlDoc);
        doc = doc.replaceAll(" \n", "\n");
        logger.debug("Jsoup.clean 1: " + doc);
        return doc;
    }

    protected String processNote(Document doc, String prependSpaces, String noteGuid, Note note) throws Exception {
        StringBuffer fullNote = new StringBuffer("");
        logger.debug("Process and extract en-media elements");
        this.processExtractMedia(doc, prependSpaces, "jpeg", noteGuid, note);
        this.processExtractMedia(doc, prependSpaces, "jpg", noteGuid, note);
        this.processExtractMedia(doc, prependSpaces, "png", noteGuid, note);
        this.processExtractMedia(doc, prependSpaces, "gif", noteGuid, note);
        Iterator nodesIt = doc.select("en-note").iterator();
        if (nodesIt.hasNext()) {
            String html = this.cleanupHTML(((Element)nodesIt.next()).html());
            doc = Jsoup.parse((String)html);
            Document.OutputSettings settings = new Document.OutputSettings();
            settings.prettyPrint(false);
            doc.outputSettings(settings);
            Elements body = doc.select("body");
            String fullDoc = body.toString();
            fullDoc = fullDoc.replaceAll("<body>", " ");
            fullDoc = fullDoc.replaceAll("</body>", " ");
            BufferedReader bufReader = new BufferedReader(new StringReader(fullDoc));
            String line = null;
            try {
                while ((line = bufReader.readLine()) != null) {
                    fullNote.append(prependSpaces);
                    fullNote.append(line);
                    fullNote.append("\n");
                }
            }
            catch (IOException ex) {
                logger.error("Reading en-note resulted in an IO Exception, skip...");
                fullNote = new StringBuffer("");
            }
            String output = this.youTubeFetcher(this.codeFetcher(fullNote));
            output = this.htmlEmbedFetcher(output, prependSpaces);
            return output.replaceAll("&nbsp;", " ");
        }
        logger.error("Document: " + doc.toString() + " has no 'en-note' element");
        return fullNote.toString();
    }

    private String codeFetcher(StringBuffer fullNote) {
        Pattern codeStartPattern = Pattern.compile("(?s)<div>(.*?)&lt;code&gt;(.*?)</div>(.*?)<div>(.*?)&lt;/code&gt;");
        Matcher matcher = codeStartPattern.matcher(fullNote);
        String prepend = "      ";
        StringBuffer output = new StringBuffer("");
        int lastEndPos = 0;
        while (matcher.find()) {
            lastEndPos = matcher.end();
            String lang = matcher.group(2).trim();
            String codePart = matcher.group(4);
            logger.debug("Code Language '" + lang + "'");
            logger.debug("Code Part Uncleaned: " + codePart);
            codePart = codePart.replaceAll("</div>", "</div>LINESEP");
            Document codeDoc = Jsoup.parse((String)codePart);
            Whitelist wl = new Whitelist();
            wl.addTags(new String[]{"br", "p"});
            codePart = codeDoc.html();
            String cleanDoc = Jsoup.clean((String)codePart, (Whitelist)wl);
            logger.debug(" Jsoup Clean; \n" + cleanDoc);
            codeDoc = Jsoup.parse((String)cleanDoc);
            codeDoc.outputSettings().prettyPrint(false);
            logger.debug("CodeDoc Clean Parsed: \n" + codeDoc.html());
            Object codeFull = this.analyzeElement((Element)codeDoc, prepend);
            codeFull = ((String)codeFull).replaceAll("LINESEP", "\n");
            String[] lineSplit = ((String)codeFull).split("\n");
            codeFull = "";
            for (int i = 0; i < lineSplit.length; ++i) {
                codeFull = (String)codeFull + prepend + lineSplit[i] + "\n";
            }
            codeFull = ((String)codeFull).replace("\u00a0", " ");
            codeFull = ((String)codeFull).replaceAll("&nbsp;", " ");
            logger.debug("Code Part Ready: \n" + (String)codeFull);
            output.append(prepend + "<div>" + matcher.group(1) + "\n" + prepend + "``` " + matcher.group(2) + "\n  " + (String)codeFull + "\n" + prepend + "```\n");
        }
        output.append("\n" + prepend + fullNote.substring(lastEndPos));
        return output.toString();
    }

    private String youTubeFetcher(String fullNote) {
        String regPattern = "(?s)(.*?)&lt;video-youtube&gt;(.*?)&lt;/video-youtube&gt;(.*?)";
        String replacementStr = "$1<div class=\"responsive-video\"><iframe src=\"https://www.youtube.com/embed/$2?rel=0\" frameborder=\"0\" allowfullscreen></iframe></div>$3";
        return fullNote.replaceAll(regPattern, replacementStr);
    }

    private String htmlEmbedFetcher(String fullNote, String prependSpaces) {
        String startTag = "&lt;htmlembed&gt;";
        String stopTag = "&lt;/htmlembed&gt;";
        String patterTxt = "(?s)(.*?)" + startTag + "(.*?)" + stopTag + "(.*?)";
        if (((String)fullNote).contains("&lt;htmlembed&gt;")) {
            Pattern embedPattern = Pattern.compile(patterTxt);
            Matcher matcher = embedPattern.matcher((CharSequence)fullNote);
            while (matcher.find()) {
                String txt2 = matcher.group(2);
                txt2 = txt2.replace("<br>", "");
                txt2 = txt2.replace("&lt;", "<");
                txt2 = txt2.replace("&gt;", ">");
                fullNote = ((String)fullNote).substring(0, matcher.start(2) - startTag.length()) + txt2 + ((String)fullNote).substring(matcher.end(2) + stopTag.length());
                matcher = embedPattern.matcher((CharSequence)fullNote);
            }
        }
        return fullNote;
    }

    private String analyzeElement(Element cell, String prepend) {
        Object text = "";
        List childNodes = cell.childNodes();
        for (int i = 0; i < childNodes.size(); ++i) {
            Node childNode = (Node)childNodes.get(i);
            if (childNode instanceof TextNode) {
                text = (String)text + ((TextNode)childNode).getWholeText();
                continue;
            }
            if (!(childNode instanceof Element)) continue;
            text = (String)text + this.analyzeElement((Element)childNode, prepend);
        }
        return text;
    }

    protected void processExtractMedia(Document doc, String prependSpaces, String mime, String noteGuid, Note note) throws Exception {
        Elements elems = doc.select("en-media[type$=" + mime + "]");
        for (Element elem : elems) {
            String hash = elem.attr("hash");
            String img = " img1_" + hash + "." + mime + " ";
            logger.debug("Extend en-note with image tag " + img);
            elem.prepend(img);
            Resource res = this.noteStore.getResourceByHash(noteGuid, BlogGenerator.hexStringToByteArray(hash), true, false, false);
            this.extractMediaResource(res, this.imageDirectory, hash, note);
        }
    }

    protected void processExtractImgTag(Document doc, String prependSpaces, String noteGuid, Note note) throws Exception {
        Elements elems = doc.select("img");
        for (Element elem : elems) {
            String link = elem.attr("src");
            String fileName = link.substring(link.lastIndexOf(47) + 1, link.length());
            String hash = fileName.substring(0, fileName.lastIndexOf(46));
            String img = " img1_" + fileName + " ";
            logger.debug("Extend en-note with image1 tag " + img);
            elem.prepend(img);
            Resource res = this.noteStore.getResourceByHash(noteGuid, BlogGenerator.hexStringToByteArray(hash), true, false, false);
            this.extractMediaResource(res, this.imageDirectory, hash, note);
        }
    }

    protected void extractMediaResource(Resource res, String imageDir, String hashCode, Note note) throws Exception {
        BufferedImage renderedImg;
        int imgSize = 400;
        int imgSizeFull = 878;
        int tbimgSize = 200;
        int tb1imgSize = 80;
        if (this.hasLightBox(note)) {
            imgSizeFull = 1520;
        }
        String mime = res.getMime().split("/")[1];
        Resource resource = this.noteStore.getResource(res.getGuid(), true, false, true, false);
        String fullFiName = imageDir + "/" + hashCode + "." + mime;
        String tbFiName = imageDir + "/tb-" + hashCode + "." + mime;
        String tb1FiName = imageDir + "/tb1-" + hashCode + "." + mime;
        DataOutputStream os = new DataOutputStream(new FileOutputStream(fullFiName));
        os.write(resource.getData().getBody());
        os.close();
        BufferedImage img = ImageIO.read(new File(fullFiName));
        logger.debug("Got image with width " + img.getWidth() + "/ height " + img.getHeight());
        if (!this.hasNoPullImage(note)) {
            if (img.getWidth() > imgSize) {
                logger.debug("Resize the image");
                renderedImg = Scalr.resize((BufferedImage)img, (int)imgSize, (BufferedImageOp[])new BufferedImageOp[0]);
            } else {
                renderedImg = img;
            }
        } else if (img.getWidth() > imgSize) {
            logger.debug("Resize the image - no pull");
            renderedImg = Scalr.resize((BufferedImage)img, (int)imgSizeFull, (BufferedImageOp[])new BufferedImageOp[0]);
        } else {
            renderedImg = img;
        }
        ImageIO.write((RenderedImage)renderedImg, mime, new File(fullFiName));
        renderedImg = Scalr.resize((BufferedImage)img, (int)tbimgSize, (BufferedImageOp[])new BufferedImageOp[0]);
        ImageIO.write((RenderedImage)renderedImg, mime, new File(tbFiName));
        renderedImg = Scalr.resize((BufferedImage)img, (Scalr.Method)Scalr.Method.SPEED, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)tb1imgSize, (int)tb1imgSize, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS, Scalr.OP_BRIGHTER});
        ImageIO.write((RenderedImage)renderedImg, mime, new File(tb1FiName));
    }

    protected boolean hasBlogImages(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.utility.hasBlogImages(note);
    }

    protected boolean hasFixedImagePosition(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.utility.hasFixedImagePosition(note);
    }

    protected boolean hasNoPullImage(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.utility.hasNoPullImage(note);
    }

    protected boolean hasPullRightImage(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.utility.hasPullRight(note);
    }

    protected boolean hasLightBox(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.utility.hasLightbox(note);
    }

    protected boolean hasNoBorderImage(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.utility.hasNoBorder(note);
    }

    protected boolean hasLightBoxTitle(Note note) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.utility.hasLightboxTitle(note);
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

