package com.cloudburo.evernote;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoHelper {

    static final String youTubeUrlRegEx = "^(https?)?(://)?(www.)?(m.)?(youtube\\.com|youtu\\.be)/";
    static final String[] youTubeVideoIdRegex = { "\\?vi?=([^&]*)","watch\\?.*v=([^&]*)", "(?:embed|vi?)/([^/?]*)", "^([A-Za-z0-9\\-\\_]*)"};

    static final Logger logger = LoggerFactory.getLogger(VideoHelper.class);	
    
    public static String extractVideoIdFromUrl(String url) {
    	
    	if (url.contains("youtube")||url.contains("youtu.be")) {
	        String youTubeLinkWithoutProtocolAndDomain = youTubeLinkWithoutProtocolAndDomain(url);
	        for(String regex : youTubeVideoIdRegex) {
	            Pattern compiledPattern = Pattern.compile(regex);
	            Matcher matcher = compiledPattern.matcher(youTubeLinkWithoutProtocolAndDomain);
	
	            if(matcher.find()){
	                return matcher.group(1);
	            }
	        }
    	}
        return "";
    }

    private static String youTubeLinkWithoutProtocolAndDomain(String url) {
        Pattern compiledPattern = Pattern.compile(youTubeUrlRegEx);
        Matcher matcher = compiledPattern.matcher(url);
        if(matcher.find()){
            return url.replace(matcher.group(), "");
        }
        return url;
    }
    
    public static String processVideoTags(String fullNote) {
    	//String regPattern = "(<video>.*?</video>)";
    	// // (?s) is for including carriage returns
    	String regPattern = "(&lt;video&gt;(?s).*?(?s)&lt;/video&gt;)";
		String newNote = fullNote;
		Pattern codeStartPattern = Pattern.compile(regPattern);
		Matcher matcher;
		matcher = codeStartPattern.matcher(fullNote);
        while(matcher.find()) {
            String url = matcher.group(1);
            String url1 = url.substring(13,url.length()-14);
            logger.debug("Got Video-URL "+url1);
            Document doc = Jsoup.parse(url1);
            logger.debug("Got Text content "+doc.text());
            String id = extractVideoIdFromUrl(doc.text());
            if (!id.equals("")) {
            	logger.debug("Embed Video with id '"+id+"'");
	            String html = "<div class=\"responsive-video\"><iframe src=\"https://www.youtube.com/embed/"+
	                          id+
	                          "?rel=0\" frameborder=\"0\" allowfullscreen></iframe></div>";
	            newNote = newNote.replace(url, html);
            } else {
            	logger.warn("Could not extract Video Id, going to link only");
	            String html = "<div><a href=\""+doc.text()+"\"  target=\"_blank\">Video</a></div>";
	            newNote = newNote.replace(url, html);
            }
        }
        System.out.println(newNote);
		return newNote;
    }
    
    static void main(String[] args) {
    	
    }
}

