package com.cloudburo.evernote;

import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.imgscalr.Scalr;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;


public class OctopressBlogGenerator extends BlogGenerator {
	
    static final Logger logger = LoggerFactory.getLogger(OctopressBlogGenerator.class);
	
	public OctopressBlogGenerator(String blogName, NoteStoreClient store, String targetDir,
			 boolean moveNote, boolean followLink) {
		super(blogName,store,targetDir,moveNote,followLink);
		
	}
	
 	public String getPostFilePostfix() {
 		return ".md";
 	}
	
	  private void generateOctopressMarkdownHeaderBlog(StringBuffer buff, String blogName, Note note, String fileName, 
			  String blogDateFull, StringBuffer logDescr) throws Exception {
		  String tagCategoryPrefix = blogName+"-";
		  logDescr.append("Creating Octopress Markdown File: " + fileName+"\n");
		  logger.debug("Creating Octopress Markdown File: " + fileName);
		  buff.append("---\n");
		  buff.append("layout: post\n");
		  buff.append("title: \""+note.getTitle().replace('"', '\'')+"\"\n");
		  buff.append("date: "+blogDateFull+"\n"); 
		  buff.append("comments: true\n");
		  buff.append("categories:\n");
		  if (note.getTagGuids() != null) {
			  Iterator<String> it = note.getTagGuids().iterator();
			  while (it.hasNext()) {
				  String tagName = noteStore.getTag(it.next()).getName();
				  if (tagName.startsWith(tagCategoryPrefix)) buff.append("- "+tagName.substring(tagCategoryPrefix.length())+"\n");
			  }
		  }
		  buff.append("---\n");	  
	  }
	  
	  private void generateOctopressMarkdownHeaderDocument(StringBuffer buff, String blogName, Note note, String fileName, 
			  String blogDateFull, StringBuffer logDescr) throws Exception {
		  String tagCategoryPrefix = blogName+"-";
		  logDescr.append("Creating Octopress Markdown File: " + fileName+"\n");
		  logger.debug("Creating Octopress Markdown File: " + fileName);
		  buff.append("---\n");
		  buff.append("layout: page \n");
		  buff.append("title: \""+note.getTitle().replace('"', '\'')+"\"\n"); 
		  buff.append("comments: false\n");
		  buff.append("sharing: false\n");
		  buff.append("footer: true\n");
		  buff.append("categories:\n");
		  if (note.getTagGuids() != null) {
			  Iterator<String> it = note.getTagGuids().iterator();
			  while (it.hasNext()) {
				  String tagName = noteStore.getTag(it.next()).getName();
				  if (tagName.startsWith(tagCategoryPrefix)) buff.append("- "+tagName.substring(tagCategoryPrefix.length())+"\n");
			  }
		  }
		  buff.append("---\n");	  
	  }
	  
	  public void generateNewsFile(Note note,String fileName, String blogDateFull, String doneGID, StringBuffer logDescr, int skipped) throws Exception {
		  String sourceURL = note.getAttributes().getSourceURL();
		  StringBuffer buff = new StringBuffer(); 
		  String fileName1 = fileName+".markdown";
		  generateOctopressMarkdownHeaderBlog(buff, blogName,note,fileName1,blogDateFull, logDescr);
		  Note fullNote = noteStore.getNote(note.getGuid(), true, false,false,false);
		  logger.debug(fullNote.getContent());
		  org.jsoup.nodes.Document doc = Jsoup.parse(fullNote.getContent());
		  Iterator<Element> boldsIt = doc.select("b").iterator(); 
		  if (boldsIt.hasNext()) {
			  while (boldsIt.hasNext()){
				  Element elem = boldsIt.next();
				  buff.append(elem.text()+"\n");	  
			  }
			  if (sourceURL != null)
				  buff.append("\n[Link]("+sourceURL+ ")");
			  logger.debug("CONTENT:\n" + buff.toString());	
			  File fi = new File(this.targetDir+fileName1);
			  writeToFile(fi,Charset.forName("UTF-8"),buff.toString());
			  if (moveNote) {
				  note.setNotebookGuid(doneGID);
				  noteStore.updateNote(note);
				  logger.debug("Moved processed Note");
			  }
		  } else {
			  logger.warn("Note '"+note.getTitle()+"' has no marked text, don't take it over");
			  skipped++;
		  } 
	  }
	  
	  public  void generateCurationFile( Note note,String fileName, String blogDateFull, 
			  String doneGID, StringBuffer logDescr, int skipped, boolean curationType) throws Exception {
			  StringBuffer buff = new StringBuffer(); 
			  String fileName1 = fileName+".markdown";
			  String targetDirectory = this.targetDir;

			  boolean docPage = false;
			  String imageDirectory = this.targetDir+"../img/";
			  if (note.getTagGuids() != null) {
				  Iterator<String> it = note.getTagGuids().iterator();
				  while (it.hasNext()) {
					  String tagName = noteStore.getTag(it.next()).getName();
					  /*
					  if (isIndexPage(tagName)) {
						  docPage = true;
						  fileName1 = "index.markdown";
						  if (!this.targetDir.endsWith("/"))
							  this.targetDir += "/";
						  targetDirectory = this.targetDir+"../";
					  }*/
				  }
			  }
			  
			  if (docPage)
				  generateOctopressMarkdownHeaderDocument(buff, blogName,note,fileName1,blogDateFull, logDescr);
			  else
				  generateOctopressMarkdownHeaderBlog(buff, blogName,note,fileName1,blogDateFull, logDescr);
			  
			  Vector<String> mdPics = new Vector<String>();
			  
			  // Do Image Rendering
			  Note fullNote = noteStore.getNote(note.getGuid(), true, false,false,false);
			  if (fullNote.getResources() != null) {
				  Iterator<Resource> it = fullNote.getResources().iterator();
				  Vector<Resource> picList = new Vector<Resource>();
				  while ( it.hasNext()) {
					  Resource res = it.next();
					  String mime = res.getMime().split("/")[1];
					  if ( mime.equals("gif") || mime.equals("png") || mime.equals("jpeg")) {
						  picList.add(res);
					  }  
				  }			  
				  int imgIndex=0;
				  int imgSize = 400;
				  //if (picList.size() > 1)
				  //  imgSize = 200;
				  it = picList.iterator();
				  String imgPos = "left";
				  while ( it.hasNext()) {
					  Resource res = it.next();
					  String mime = res.getMime().split("/")[1];
					  Resource resource = noteStore.getResource(res.getGuid(), true, false, true, false);
					  String fiName = fileName+"-"+Integer.toString(imgIndex)+"."+mime;
					  String fullFiName = imageDirectory+"/"+fiName;
					  DataOutputStream os = new DataOutputStream(new FileOutputStream(fullFiName));
					  os.write(resource.getData().getBody());
					  os.close();
					  BufferedImage img = ImageIO.read(new File(fullFiName));
					  BufferedImage renderedImg = Scalr.resize(img, imgSize);
					  ImageIO.write(renderedImg, mime, new File(fullFiName));
					  //buff.append("{% img "+imgPos+" /img/"+ fiName + " ["+note.getTitle()+"] %}");
					  mdPics.add("{% img "+imgPos+ " /img/"+ fiName + " '"+note.getTitle()+"' %}");
					  //if (imgPos.equals("left")) imgPos = "right"; else imgPos = "left";
					  imgPos = "";
					  imgIndex++;
				  }
			  }
			  logger.debug(fullNote.getContent());
			  
			  org.jsoup.nodes.Document doc = Jsoup.parse(fullNote.getContent());
			  Iterator<Element> nodesIt = doc.select("en-note").iterator(); 
			  // Should only have one
			  if (nodesIt.hasNext()) {	  
				  Element elem = nodesIt.next();
				  String sourceURL = note.getAttributes().getSourceURL();
				  if (sourceURL != null)
					  buff.append("\n[Link]("+sourceURL+ ")");	
				  //int count = countWords(elem.text());
				  // Read time is based on the average reading speed of an adult (roughly 275 WPM). 
				  // We take the total word count 
				  // of a post and translate it into minutes. 
				  // Then, we add 12 seconds for each inline image.
				  if (mdPics.size() > 0) {
					  buff.append(mdPics.get(0));
				  }
				  buff.append(cleanupHTML(elem.html())+"\n");			  
				  if (mdPics.size()>1) {
					  buff.append( "<!--more-->");
					  for (int i=1;i<mdPics.size();i++) {
						  buff.append(mdPics.get(i));
					  }
				  }			  
				  logger.debug("CONTENT:\n" + buff.toString());	
				  File fi = new File(targetDirectory+fileName1);
				  writeToFile(fi,Charset.forName("UTF-8"),buff.toString());
				  if (moveNote) {
					  note.setNotebookGuid(doneGID);
					  noteStore.updateNote(note);
					  logger.debug("Moved processed Note");
				  }
			  } else {
				  // TODO Get meaningful reply
				  logger.warn("Note '"+note.getTitle()+"' has en-note, don't take it over, something wrong");
				  skipped++;
			  } 
		  }
	  

}
