package com.cloudburo.evernote;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.type.Note;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class MiddleManBlogGenerator extends BlogGenerator {
	
     static final Logger logger1 = LoggerFactory.getLogger(MiddleManBlogGenerator.class);
     
     static final String imageDir = "images";
	
     public MiddleManBlogGenerator(String blogName, NoteStoreClient store, String targetDir, boolean moveNote, boolean followLink) {
			super(blogName,store,targetDir,moveNote,followLink);		
			imageDirectory = this.targetDir+"../"+imageDir+"/";
	 }
     
 	public String getPostFilePostfix() {
 		return ".html.slim";
 	}
	  
	 private void generateHeader(String guid, long updated,StringBuffer buff, String blogName, Note note, String fileName, 
			  String blogDateFull, StringBuffer logDescr,boolean docPage,String imgForHeader, String tbImgForHeader, String tbImg1ForHeader ,String shortText, String middleText) throws Exception {
		  String tagCategoryPrefix = blogName+"-";
		  logDescr.append("Creating MiddleMan Slim File: " + fileName+"\n");
		  logger1.debug("MiddleManBlogGenerator.generateHeader: Creating MiddleMan Slim File: " + fileName);
		  buff.append("---\n");
		  buff.append("guid: "+guid+"\n");
		  buff.append("update: "+updated+"\n");
		  if (docPage) {
			  buff.append("title: \""+note.getTitle().replace('"', '\'')+"\"\n");
			  buff.append("layout: simple");
		  } else {
			  buff.append("title: \""+note.getTitle().replace('"', '\'')+"\"\n");
			  buff.append("date: "+blogDateFull+"\n");
			  if (imgForHeader != null) {
				  buff.append("picture: \""+imgForHeader+"\"\n");
				  buff.append("picture_thumbn: \""+tbImgForHeader+"\"\n");
				  buff.append("picture_thumbn1: \""+tbImg1ForHeader+"\"\n");
				  
			  }
			  buff.append("shortText: \""+shortText+"\"\n");
			  buff.append("middleText: \""+middleText+"\"\n");
			  buff.append("tags: ");
			  if (note.getTagGuids() != null) {
				  Iterator<String> it = note.getTagGuids().iterator();
				  while (it.hasNext()) {
					  String tagName = noteStore.getTag(it.next()).getName();
					  if (tagName.startsWith(tagCategoryPrefix)) {
						  buff.append(tagName.substring(tagCategoryPrefix.length()));
						  if (it.hasNext()) buff.append(",");
					  }
				  }
			  }
		  }
		  buff.append("\n---\n");	
	  }
	 
	  public void generateBlogImages(Note note,String doneGID) throws Exception {
		  logger.debug("MiddleManBlogGenerator.generateBlogImages: BlogImages Note detected");
		  String noteGuid = note.getGuid();
		  long noteUpdated = note.getUpdated();
		  Note fullNote = noteStore.getNote(noteGuid, true, false,false,false);
		  org.jsoup.nodes.Document doc = Jsoup.parse(fullNote.getContent());
		  doc.outputSettings().prettyPrint(false);
		  String htmlDoc = processNote(doc,"    ", fullNote.getGuid(), note);
		  logger.debug("MiddleManBlogGenerator.generateBlogImages: Extracted Note: "+htmlDoc);
		  String[] splits = htmlDoc.split("img1_");
		  StringBuffer bgImgBuf = new StringBuffer();
		  boolean found = false;
		  int pos = 0;
		  for (int i=0;i<splits.length;i++) {
			  logger.debug("MiddleManBlogGenerator.generateBlogImages: Split Check "+i+":"+splits[i]);
			  if (Character.isLetterOrDigit((splits[i].charAt(0)))) {
				  found = true;
				  pos = pos + 1;
				  String[]lineSplit = splits[i].split(" ");
				  bgImgBuf.append("backgroundImage_" + pos + ": /images/" + lineSplit[0].trim() + "\n");
			  }
		  	/*
		  		if (splits[i].contains("<img") || splits[i].contains("_img"))   {
					Pattern p = Pattern.compile("<img[^>]+src=\"([^\">]+)\"");
					Matcher m = p.matcher(splits[i]);
					if (m.find()) {
						found = true;
						bgImgBuf.append("backgroundImage_"+pos+": /images/"+m.group(1)+"\n");
						String fileName = m.group(1).substring(+m.group(1).lastIndexOf('/') + 1);
						bgImgBuf.append("backgroundImage_"+pos+": /images/"+fileName+"\n");
						pos++;
					}
				}
			*/
		  }
		  if (!found) {
			  bgImgBuf.append("backgroundImage_1:");
		  }
		  logger.debug("MiddleManBlogGenerator.generateBlogImages: Got image note: "+bgImgBuf);
		  File fi = new File(this.targetDir+"../../data/"+"blogImages.yml");
	      writeToFile(fi,Charset.forName("UTF-8"),bgImgBuf.toString());
		  if (moveNote) {
			  note.setNotebookGuid(doneGID);
			  noteStore.updateNote(note);
			  logger1.debug("MiddleManBlogGenerator.generateBlogImages: Moved processed Note");
		  }
	  }
	 
	  public  void generateCurationFile( Note note,String fileName, String blogDateFull, 
		  String doneGID, StringBuffer logDescr, int skipped,boolean curationType) throws Exception {
		  StringBuffer curatedNote = new StringBuffer(); 
		  String fileName1 = fileName+".html.slim";
		  String targetDirectory = this.targetDir;
		  String space3 = "      ";
		  String space2 = "    ";
		  String space1 = "  ";	
		  String imgForHeader = null;
		  String tbImgForHeader = null;
		  String tbImg1ForHeader = null;
		  String shortText = "";
		  String middleText = "";
		  
		  // For Blog Images note, we don't process the note
		  if (hasBlogImages(note)) {
			  generateBlogImages(note,doneGID);
			  return;
		  }

		  boolean docPage = false;
		  if (note.getTagGuids() != null) {
			  Iterator<String> it = note.getTagGuids().iterator();
			  while (it.hasNext()) {
				  String tagName = noteStore.getTag(it.next()).getName();
				  if (isMenuPage(tagName)) {
					  docPage = true;
					  curationType = true;
					  fileName1 = getMenuFileName(tagName)+".html.slim";
					  if (!this.targetDir.endsWith("/"))
						  this.targetDir += "/";
					  targetDirectory = this.targetDir+"../";
				  }
			  }
		  }
		  String noteGuid = note.getGuid();
		  long noteUpdated = note.getUpdated();
		  Note fullNote = noteStore.getNote(noteGuid, true, false,false,false);

		  logger.debug("MiddleManBlogGenerator.generateCurationFile: Full Evernote Note: "+fullNote.getContent());
		  org.jsoup.nodes.Document doc = Jsoup.parse(fullNote.getContent());
		  doc.outputSettings().prettyPrint(false);
		  
		  String allText = doc.select("en-note").text();
		  allText = allText.replaceAll("\\s+"," ");
		  allText = allText.replaceAll("\"","'");
		  String htmlDoc = "";
		  logger.debug("MiddleManBlogGenerator.generateCurationFile: Extracted Note: "+allText);

		  // In case of the News type message take over only the bold content
		  if (!curationType) {
			  StringBuffer buff = new StringBuffer();
			  Iterator<Element> boldsIt = doc.select("b").iterator(); 
			  if (!boldsIt.hasNext()) {
				  boldsIt = doc.select("strong").iterator(); 
			  }
			  if (!boldsIt.hasNext()) {
				  boldsIt = doc.select("[style*=font-weight: bold]").iterator();
			  }
			  if (!boldsIt.hasNext()) {
				  logger.warn("MiddleManBlogGenerator.generateCurationFile: News Note without bold content");
			  }
			  if (boldsIt.hasNext()) {
			  	  allText = "";
				  while (boldsIt.hasNext()){
					  Element elem = boldsIt.next();
					  buff.append(space3+elem.text()+"<br/>\n");
					  allText += elem.text();
				  }
			  }
			  htmlDoc = buff.toString();
		  } else {
			  htmlDoc = processNote(doc,space3, fullNote.getGuid(), note);
		  }
		  int len = allText.length();
		  if (len > 100) len = 100;
		  shortText= allText.substring(0, len);
		  len = allText.length();
		  if (len > 250) len = 250;
		  middleText = allText.substring(0, len);
		  // Process and inject the images
		  // =============================
		  // In case the note hasn't a fixed image position what the default is
		  // the firstImage will be place at the beginning of the note
		  boolean firstImage = !hasFixedImagePosition(note);
		  String imgPos = "<img class='pull-left img-responsive article";
		  if (this.hasPullRightImage(note)) {
			  imgPos = "<img class='pull-right img-responsive article";
		  }
		  else if (this.hasNoPullImage(note)) {
			  imgPos = "<img class='article ";
		  }
		  if (this.hasNoBorderImage(note)) {
		  	imgPos += "' style=\"max-width:100%\" ";
		  } else {
		  	imgPos += " img-thumbnail' ";
		  }

		  if (htmlDoc.equals("")) {
			  skipped++;
		  }  else { 
		    String sourceURL = note.getAttributes().getSourceURL();
		    if (sourceURL != null) {
		    	if (followLink) {
		    	  htmlDoc = htmlDoc + space3 +"[Link]("+sourceURL+ ")";
		    	} else {
		    		htmlDoc = htmlDoc + space3 +"<a href='"+sourceURL+"' rel='nofollow'>Link</a>"; 
		    	}
		    }
		    String[] splits = htmlDoc.split("img1_");
		    StringBuffer articleContent = new StringBuffer();
		    if (splits.length ==0) {
		    	articleContent.append(space1+"div.article\n");
		    	articleContent.append(space2+"markdown:\n");
		    	articleContent.append(htmlDoc);
		    }
			else {
				boolean firstImageForHeader = true;
				for (int i=0;i<splits.length;i++) {
					if (!Character.isLetterOrDigit((splits[i].charAt(0)))) {
						articleContent.append(space1+"div.article\n");
						articleContent.append(space2+"markdown:\n");
						articleContent.append(space3+"<span/>");
						articleContent.append(splits[i]);
					} else {
						// Image section
						String[] lineSplit = splits[i].split(" ");
						String prefixSpace = space3+"   ";
						String str = splits[i].toString();
						int pos =0;
						while (str.charAt(pos) == ' ') {
							prefixSpace += " ";
							pos++;
						}

						if (firstImage) {
							String tmp = space1+"markdown:\n";
							tmp += space2+imgPos+"src='/images/"+lineSplit[0].trim()+"'>\n";
						    tmp += "\n"+articleContent.toString();
						    articleContent = new StringBuffer(tmp);
						    firstImage = false;
						} else {
							if (hasLightBox(note)) {
							  articleContent.append("\n"+prefixSpace+"<a data-toggle='lightbox' href='/images/"+lineSplit[0].trim()+"'/>");
							  articleContent.append("\n  "+prefixSpace+imgPos+"src='/images/tb-"+lineSplit[0].trim()+"'>");
							}
							else {
						      articleContent.append("\n"+prefixSpace+imgPos+"src='/images/"+lineSplit[0].trim()+"'>");
							}
						}
					    if (firstImageForHeader) {
						  firstImageForHeader = false;
						  imgForHeader = "/images/"+lineSplit[0].trim();
						  tbImgForHeader = "/images/tb-"+lineSplit[0].trim();
						  tbImg1ForHeader = "/images/tb1-"+lineSplit[0].trim();
					    }
						String[] endOfLineSplit = splits[i].split(lineSplit[0]);
						if (endOfLineSplit.length == 2) {
						  articleContent.append("\n"+space1+"div.article\n");
						  articleContent.append(space2+"markdown:\n");
						  articleContent.append(space3+"<span/>");
						  articleContent.append(endOfLineSplit[1]);
						}
					}
				}
			}
			generateHeader(noteGuid, noteUpdated, curatedNote, blogName,note,fileName1,blogDateFull, logDescr,docPage,imgForHeader,tbImgForHeader, tbImg1ForHeader, shortText,middleText);
			curatedNote.append("div.row\n");
		    curatedNote.append(articleContent.toString());
		  }
		  // Some clean up
		  String cleanedNote = curatedNote.toString().replaceAll("&nbsp;"," ");
		  
		  logger1.debug("MiddleManBlogGenerator.generateCuration curatedNote:\n" + curatedNote.toString());
		  File fi = new File(targetDirectory+fileName1);
	      writeToFile(fi,Charset.forName("UTF-8"),cleanedNote);
		  if (moveNote) {
			  note.setNotebookGuid(doneGID);
			  noteStore.updateNote(note);
			  logger1.debug("MiddleManBlogGenerator.generateCurationFile.Moved processed Note");
		  }
		  
	  }  
}
