package com.cloudburo.evernote;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.evernote.auth.EvernoteAuth;
import com.evernote.auth.EvernoteService;
import com.evernote.clients.ClientFactory;
import com.evernote.clients.NoteStoreClient;
import com.evernote.clients.UserStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.userstore.UserStore;
import com.evernote.thrift.TException;
import com.evernote.thrift.transport.TTransportException;

public class EvernoteInfo {
	
	  private UserStoreClient userStore;
	  private NoteStoreClient noteStore;
	  
	  static final Logger logger = LoggerFactory.getLogger(EvernoteInfo.class);
	
	  public EvernoteInfo(String token, Boolean productionEnv ) throws 
	  	EDAMSystemException,EDAMUserException,TTransportException,TException, EDAMNotFoundException  {
	    // Set up the UserStore client and check that we can speak to the server
		EvernoteAuth evernoteAuth;
		if (productionEnv)
			evernoteAuth = new EvernoteAuth(EvernoteService.PRODUCTION, token);
		else  
			evernoteAuth = new EvernoteAuth(EvernoteService.SANDBOX, token);
	    ClientFactory factory = new ClientFactory(evernoteAuth);
	    userStore = factory.createUserStoreClient();
	    noteStore = factory.createNoteStoreClient();

	    boolean versionOk = userStore.checkVersion("Evernote EDAMDemo (Java)",
	        com.evernote.edam.userstore.Constants.EDAM_VERSION_MAJOR,
	        com.evernote.edam.userstore.Constants.EDAM_VERSION_MINOR);
	    if (!versionOk) {
	      logger.error("Incompatible Evernote client protocol version");
	      System.exit(1);
	    }
	    // Set up the NoteStore client
	    //noteStore = factory.createNoteStoreClient();

	  }
	  
	  public int getUserId() throws Exception {
		  return userStore.getUser().getId();
	  }
	  
	  public String getUserEmail() throws Exception {
		  return userStore.getUser().getEmail();
	  }
	  
	  public String getUserName() throws Exception {
		  return userStore.getUser().getUsername();
	  }
	  
	  public String getName() throws Exception {
		  return userStore.getUser().getName();
	  }
	  
	  public String getNotebookName(String notebookGuid) throws Exception {
		  Notebook nb = noteStore.getNotebook(notebookGuid);
		  return nb.getName();
	  }
	  
	  public void revokeLongSession() throws Exception {
	  		userStore.revokeLongSession();
		}	
}
