package com.cloudburo.groovy.github

//import org.apache.log4j.Logger
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import groovyx.net.http.HTTPBuilder
import static groovyx.net.http.Method.GET
import static groovyx.net.http.Method.POST
import static groovyx.net.http.Method.DELETE
import static groovyx.net.http.ContentType.TEXT
import static groovyx.net.http.ContentType.JSON
import static groovyx.net.http.ContentType.URLENC

import java.security.KeyStore
import org.apache.http.conn.scheme.Scheme
import org.apache.http.conn.ssl.SSLSocketFactory
import org.apache.http.conn.ssl.AllowAllHostnameVerifier

// https://developer.github.com/v3/

class HttpHandler extends Handler {
	
	//static final Logger logger = Logger.getLogger(HttpHandler.class)
	static final Logger logger = LoggerFactory.getLogger(HttpHandler.class);
	
	HTTPBuilder httpClient
	String gitUser
	
	public HttpHandler(String user, String password, int i) {
		gitUser = user
		httpClient = new HTTPBuilder("https://api.github.com")
		httpClient.headers['Authorization'] = 'Basic '+"${user}:${password}".getBytes('iso-8859-1').encodeBase64()
		httpClient.headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
	}
	
	public HttpHandler(String user, String token) {
		gitUser = user
		httpClient = new HTTPBuilder("https://api.github.com")
		httpClient.headers.'Authorization' = "token ${token}"
		httpClient.headers.'Accept' = 'application/vnd.github.v3.text-match+json'
		httpClient.headers.'User-Agent' = 'Mozilla/5.0'
	}

	
	public boolean checkRepositoryExistence(String reposName) {	
		httpClient.request( GET, JSON ) {
			uri.path = "/users/${gitUser}/repos"
			// uri.query = [ v:'1.0', q: 'Calvin and Hobbes' ]
			logger.debug("URI: ${uri}")
			headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
			
			// response handler for a success response code:
			boolean found = false
			response.success = { resp, json ->
			  json.each {
				  if ( it.name == reposName) { found = true; return  }
			  }
			  return found
			}
			// response handler for any failure status code:
			response.failure = { resp ->
			  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
			  throw new Exception("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
			}	
		}
    } 
	
	public String getRepositoryAttribute(String reposName, String attrName) {
	  httpClient.request( GET, JSON ) {
		uri.path = "/users/${gitUser}/repos"
		logger.debug("URI: ${uri}")
		// response handler for a success response code:
		String attr = ""
		response.success = { resp, json ->
		  json.each {
			  if ( it.name == reposName) { 
				  attr = it[attrName]
				  return  
			  }
		  }
		  return attr
		}
		// response handler for any failure status code:
		response.failure = { resp ->
		  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
		  throw new Exception("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
		}
	  }
    }
	
	public String createRepository(String reposName, String organization, String description) {
		logger.debug("Create Repository ${reposName}")
		httpClient.request( POST, JSON ) { req ->
			if (organization == "") {
				uri.path = "/user/repos"
			} else {
			uri.path = "/orgs/${organization}/repos"
			}
			//requestContentType = URLENC
			body = [
				name : reposName,
				description: description,
				homepage: "https://github.com"
			  ]
			logger.debug("URI: ${uri}")
			response.success = { resp ->
				return ""
			}
			// response handler for any failure status code:
			response.failure = { resp, json ->
			  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			  
			  throw new GithubException("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			}
		}
	}
	
	public void deleteRepository(String owner, String repos) {
		println "Delete ${owner} ${repos}"
		logger.debug("Delete Repository ${repos} for ${owner}")
		httpClient.request( DELETE ) { req ->
			uri.path = "/repos/${owner}/${repos}"
			logger.debug("URI: ${uri}")
			headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
			response.success = { resp, json ->
				println json
			}
			response.'204' = { resp, json ->
				println json
				
			}
			// response handler for any failure status code:
			response.failure = { resp, json ->
			  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			  throw new GithubException("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			}
		}
	}
}
