package com.cloudburo.groovy.github

//import org.apache.log4j.Logger
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import groovyx.net.http.HTTPBuilder
import static groovyx.net.http.Method.GET
import static groovyx.net.http.Method.POST
import static groovyx.net.http.Method.DELETE
import static groovyx.net.http.ContentType.TEXT
import static groovyx.net.http.ContentType.JSON
import static groovyx.net.http.ContentType.URLENC

import java.security.KeyStore
import org.apache.http.conn.scheme.Scheme
import org.apache.http.conn.ssl.SSLSocketFactory
import org.apache.http.conn.ssl.AllowAllHostnameVerifier

// https://developer.github.com/v3/

class BitBucketHttpHandler extends Handler {
	
	//static final Logger logger = Logger.getLogger(BitBucketHttpHandler.class)
	static final Logger logger = LoggerFactory.getLogger(BitBucketHttpHandler.class);
	
	HTTPBuilder httpClient
	String gitUser
	String password
	String token
	String APIVERSION="2.0"
	boolean basic
	
	public BitBucketHttpHandler(String user, String password, boolean basic) {
		this.gitUser = user
		this.basic = basic
		
		httpClient = new HTTPBuilder("https://api.bitbucket.org")
		if (basic) {
		    httpClient.headers['Authorization'] = 'Basic '+"${user}:${password}".getBytes('iso-8859-1').encodeBase64()
		    httpClient.headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
			this.password = password
		} else {
		    httpClient.headers.'Authorization' = "token ${token}"
		    // httpClient.headers.'Accept' = 'application/vnd.github.v3.text-match+json'
		    httpClient.headers.'User-Agent' = 'Mozilla/5.0'
			this.token = password
		}
	}
	
	public void applySecurityHeaders(HTTPBuilder httpClient) {
		if (basic) {
			httpClient.headers['Authorization'] = 'Basic '+"${gitUser}:${password}".getBytes('iso-8859-1').encodeBase64()
			httpClient.headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
		} else {
			httpClient.headers.'Authorization' = "token ${token}"
			httpClient.headers.'Accept' = 'application/vnd.github.v3.text-match+json'
			httpClient.headers.'User-Agent' = 'Mozilla/5.0'
		}
	}

	public boolean checkRepositoryExistence(String reposName) {	
		httpClient.request( GET, JSON ) {
			uri.path = "/${APIVERSION}/repositories/${gitUser}"
			logger.debug("URI: ${uri}")
			headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
			boolean found = false
			int pagelen, page, pagesz
			String nxt
			response.success = { resp, json ->
			  json.each {
				  if (it.key == 'values') {
					  it.value.each { elem ->
				         if ( elem.name == reposName) { found = true; return  }
					  }
				  }
				  if (it.key == 'pagelen') pagelen = it.value
				  if (it.key == 'page') page = it.value
				  if (it.key == 'size') pagesz = it.value
				  if (it.key == 'next') nxt = it.value
				  
			  }
			  logger.debug("Page Attr: ${pagelen}, ${page},${pagesz},${nxt},${found}")
			  if (!found && nxt != null)  checkRepositoryExistenceNextPage(nxt,reposName)
			  else return found
			}
			// response handler for any failure status code:
			response.failure = { resp ->
			  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
			  throw new Exception("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
			}	
		}

    }
	
	private boolean checkRepositoryExistenceNextPage(String uriNext, String reposName) {
		HTTPBuilder builder = new HTTPBuilder(uriNext)
		applySecurityHeaders(builder)
		builder.request( GET, JSON ) {
			logger.debug("URI Next Page: ${uri.path}")
			headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
			boolean found = false
			int pagelen, page, pagesz
			String nxt
			response.success = { resp, json ->
			  json.each {
				  if (it.key == 'values') {
					  it.value.each { elem ->
						 if ( elem.name == reposName) { found = true; return  }
					  }
				  }
				  if (it.key == 'pagelen') pagelen = it.value
				  if (it.key == 'page') page = it.value
				  if (it.key == 'size') pagesz = it.value
				  if (it.key == 'next') nxt = it.value
	
			  }
			  logger.debug("Page Attr: ${pagelen}, ${page},${pagesz},${nxt}")
			  if (found) return true;
			  if (nxt == null) return false;
			  checkRepositoryExistenceNextPage(nxt, reposName)
			  
			}
			// response handler for any failure status code:
			response.failure = { resp ->
			  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
			  throw new Exception("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
			}
		}
	} 
	
	public String getRepositoryAttribute(String reposName, String attrName) {
	  httpClient.request( GET, JSON ) {
		uri.path = "/${APIVERSION}/repositories/${gitUser}/${reposName}"
		logger.debug("URI: ${uri}")
		// response handler for a success response code:
		String attr = ""
		response.success = { resp, json ->
		  json.each {
			  if (it.key == attrName)  attr = it.value
		  }
		  return attr
		}
		// response handler for any failure status code:
		response.failure = { resp ->
		  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
		  throw new Exception("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase}")
		}
	  }
    }
	
	public String createRepository(String reposName, String organization, String description) {
		logger.debug("Create Repository ${reposName}")
		httpClient.request( POST, JSON ) { req ->

			uri.path = "/${APIVERSION}/repositories/${gitUser}/${reposName}"
			//requestContentType = URLENC
			body = [
				name : reposName,
				description: description,
				is_private: "true"
			  ]
			logger.debug("URI: ${uri}")
			response.success = { resp ->
				return ""
			}
			// response handler for any failure status code:
			response.failure = { resp, json ->
			  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			  
			  throw new GithubException("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			}
		}
	}
	
	public void deleteRepository(String owner, String repos) {
		println "Delete ${owner} ${repos}"
		logger.debug("Delete Repository ${repos} for ${owner}")
		httpClient.request( DELETE ) { req ->
			uri.path = "/${APIVERSION}/repositories/${owner}/${repos}"
			logger.debug("URI: ${uri}")
			headers.'User-Agent' = 'Mozilla/5.0 Ubuntu/8.10 Firefox/3.0.4'
			response.success = { resp, json ->
				println json
			}
			response.'204' = { resp, json ->
				println json
				
			}
			// response handler for any failure status code:
			response.failure = { resp, json ->
			  logger.error("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			  throw new GithubException("Unexpected error: ${resp.statusLine.statusCode} : ${resp.statusLine.reasonPhrase} : ${json}")
			}
		}
	}
}
