package com.cloudburo.groovy.blogen

import com.cloudburo.utility.AwsS3

import groovy.util.logging.Slf4j;

import java.util.Hashtable

@Slf4j
class AwsKMSDecryptor implements Decryptor {
	
	private String bucket
	
	private Hashtable<String,String> encStore = new Hashtable<String,String>()
	
	public AwsKMSDecryptor() {	}

	public String decrypt(String path, String key) {
		String value = encStore.get(key)
		if (value != null) return value
		if (path.startsWith("/")) path = path.substring(1)
		log.debug("AwsKMSDecryptor.decrypt: Calling S3 for bucket ${bucket} ans ${path}/${key}")
		String decryptStr = AwsS3.getObject(bucket, "${path}/${key}")
		if (decryptStr != null) {
			encStore.put(key, decryptStr)
			log.debug("AwsKMSDecryptor.decrypt: Added decrypted string for key ${key} to encryption cache")
		}
		return decryptStr
	}
	
	// Invalidate an entry in case of connection problems
	public void invalidateEntry(key) {
		String val = encStore.remove(key)
		if (val != null) {
			log.debug("AwsKMSDecryptor.invalidateEntry: Removed key ${key} from encryption cache")
		} else {
			log.debug("AwsKMSDecryptor.invalidateEntry: Key ${key} not found in encryption cache")
		}
	}
	
	public void setLocalDirOrBucket(String bucket) {
		//s3://tst.ms.curationplatform.us-west-2/test
		this.bucket = bucket
	}

}
