package com.cloudburo.groovy.blogen

import groovy.util.logging.Slf4j;

import java.io.File;

import com.cloudburo.utility.Cryptor

@Slf4j
class OpenSSLDecryptor implements Decryptor {

	private Cryptor cryp;
	private String localDirOrBucket ="";
	
	public OpenSSLDecryptor() {
		cryp = new Cryptor();
	}

	public String decrypt(String path, String fileName) {
		cryp.credentialsPath = localDirOrBucket+path
		log.debug("Calling decrypt with local config dir ${localDirOrBucket}")
		return cryp.decrypt(fileName)
	}
	
	public void invalidateEntry(key) {}
	
	public void setLocalDirOrBucket(String path) {
		log.debug("OpenSSLDecryptor setting local config dir ${path}")
		localDirOrBucket = path
	}
	

}
