package com.cloudburo.groovy.blogen

import groovy.util.logging.Slf4j;

import com.cloudburo.groovy.blogen.OpenSSLDecryptor
import com.cloudburo.groovy.blogen.AwsKMSDecryptor

@Slf4j
class DecryptorFactory {
	
	public enum factoryType {
		OPENSSL, AWSKMS
	}

	static Decryptor createDectyptor (factoryType type,String localConfigDir) {
		if (factoryType.OPENSSL == type) {
		  log.debug("Creating Open SSL Decryptor")
		  Decryptor dec=  new OpenSSLDecryptor()
		  dec.setLocalDirOrBucket(localConfigDir)
		  return dec
		}
		else {
		  log.debug("Creating AWS KMS Decryptor")
		  return new AwsKMSDecryptor()
		}
	}

}
