package com.cloudburo.groovy.blogen

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
//import org.apache.log4j.Logger
//import org.apache.log4j.xml.DOMConfigurator;

import com.cloudburo.evernote.BlogGenerator;
import com.cloudburo.utility.Utilities

class BlogTemplateSetup   {
	
	//static final Logger logger = Logger.getLogger(BlogTemplateSetup.class)
	static final Logger logger = LoggerFactory.getLogger(BlogTemplateSetup.class);

	static void main(def args) throws MalformedURLException {
			// Read in 'config.groovy' for the development environment.
			// Either dev or test or prod 
		    assert args[0]
			// Config File Directory
			assert args[1]
			// Blog Identifier
			assert args[2]
			def blogId = args[2]
			assert args[3]
			def step = args[3]
			
			ConfigObject conf = new ConfigSlurper(args[0]).parse(new File(args[1]+"config.groovy").toURI().toURL());		
			final Map config = conf.flatten();
			
			// Setup Logging
			assert config.get("app.log4j")
			//DOMConfigurator.configure(config.get("app.log4j"))
			//logger.debug("Loaded Log4j XML File "+config.get("app.log4j"))
			
			String rootDir = config.get("app.deployDir")
			if (!rootDir.endsWith("/")) rootDir+="/"
			
			if (args[3].equals("replaceTmplText")) {
				BlogTemplateSetup.replaceTemplateText(config,blogId)
			}
			else if (args[3].equals("fullSetup")) {

				BlogTemplateSetup.cloneTemplate( config,  blogId, rootDir)
				BlogTemplateSetup.replaceTemplateText(config,blogId)
			}
	}
	
	public static void cloneTemplate(Map config, String blogId, String rootDir) {
		File rootDirFi = new File(rootDir)
		File  gitblogdir = rootDir + blogId + "/"
		assert gitblogdir.exists() != true
		logger.debug("Cloning to "+gitblogdir)
		def ret = Utilities.executeOnShell("git clone git@bitbucket.org:talfco/blog-tmpl1.git "+blogId,rootDirFi)
		assert ret.value == 0, logger.error("Git Clone Failed with error code "+ret)
		ret = Utilities.executeOnShell("git checkout -b "+blogId,gitblogdir)
		assert ret.value == 0, logger.error("Git Branch Checkout Failed with error code "+ret)
		ret = Utilities.executeOnShell("bundle install ",gitblogdir)
		assert ret.value == 0, logger.error("Bundle install failed wih error code"+ret)
		ret = Utilities.executeOnShell("bundle exec rake generate",gitblogdir)
		assert ret.value == 0, logger.error("Rake generate failed wih error code "+ret)
		gitCheckin( gitblogdir, blogId,"initial setup")
	}
		
	public static void replaceTemplateText(Map config, String blogId, String rootDir) {
		def blogPath = rootDir + blogId + "/"
		assert config.get("blogInfo."+blogId+".title")
		assert config.get("blogInfo."+blogId+".subtitle")
		assert config.get("blogInfo."+blogId+".author")
		assert config.get("blogInfo."+blogId+".hometitle")
		assert config.get("blogInfo."+blogId+".sbcontent")
		if (config.get("blogInfo.menuEntries.entry1.name") != null) { assert config.get("blogInfo.menuEntries.entry1.server.URL")}
		
		def fidir = new File(blogPath)
		def ind = 0
		def exts = [".yml"]
		def replaceBy = [config.get("blogInfo."+blogId+".title"),
						 config.get("blogInfo."+blogId+".subtitle"),
						 config.get("blogInfo."+blogId+".author") ]
		["_TITLE_","_SUBTITLE_","_AUTHOR_"].each {
			Utilities.replaceTextInFiles(fidir,exts,it,replaceBy[ind])
			ind++
		}
		
		fidir = new File(blogPath+"source")
		ind = 0
		exts = [".markdown",".html"]
		replaceBy = [config.get("blogInfo."+blogId+".hometitle"),
					 config.get("blogInfo."+blogId+".sbcontent") ]
		["%HOMETITLE%","%SIDEBARCONTENT%"].each {
			 Utilities.replaceTextInFiles(fidir,exts,it,replaceBy[ind])
			 ind++
		}
		
		exts = [".html"]
		["%GOTONAME%/","%GOTOLINK%"]
		gitCheckin( blogPath, blogId,"replacementStep")
		
	}
	
	private static void gitCheckin(File gitblogdir, blogId,txt) {
		def ret
		ret = Utilities.executeOnShell("git add --all",gitblogdir)
		assert ret.value == 0, logger.error("Git add all failed wih error code "+ret)
		ret = Utilities.executeOnShell("git commit -m '"+txt+"'",gitblogdir)
		assert ret.value == 0, logger.error("Git commit failed wih error code "+ret)
		ret = Utilities.executeOnShell("git push -u origin "+blogId,gitblogdir)
		assert ret.value == 0, logger.error("Git push origin failed wih error code "+ret)
	}
}
