/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.goyeneche.responses;

import net.chesstango.goyeneche.UCIGui;
import net.chesstango.goyeneche.responses.UCIResponse;

public final class RspOption
implements UCIResponse {
    private final String name;
    private final OptionType type;
    private final String defaultValue;
    private final String minValue;
    private final String maxValue;

    RspOption(String name, OptionType type, String defaultValue, String minValue, String maxValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void execute(UCIGui executor) {
        executor.do_option(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("option name ");
        sb.append(this.name).append(" type ").append(this.type.toString().toLowerCase());
        if (this.defaultValue != null) {
            sb.append(" default ").append(this.defaultValue);
        } else if (OptionType.STRING.equals((Object)this.type)) {
            sb.append(" default ").append("<empty>");
        }
        if (this.minValue != null) {
            sb.append(" minValue ").append(this.minValue);
        }
        if (this.maxValue != null) {
            sb.append(" maxValue ").append(this.maxValue);
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public OptionType getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public static enum OptionType {
        CHECK,
        STRING,
        COMBO,
        BUTTON,
        SPIN;

    }
}

