/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.goyeneche.requests;

import java.util.List;
import net.chesstango.goyeneche.UCIEngine;
import net.chesstango.goyeneche.requests.UCIRequest;

public final class ReqPosition
implements UCIRequest {
    private final CmdType type;
    private final String fen;
    private final List<String> moves;

    ReqPosition(String fen, List<String> moves) {
        this.type = CmdType.FEN;
        this.fen = fen;
        this.moves = moves;
    }

    ReqPosition(List<String> moves) {
        this.type = CmdType.STARTPOS;
        this.fen = null;
        this.moves = moves;
    }

    @Override
    public void execute(UCIEngine executor) {
        executor.do_position(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("position ");
        if (CmdType.STARTPOS.equals((Object)this.type)) {
            sb.append("startpos");
        } else {
            sb.append("fen ").append(this.fen);
        }
        if (this.moves != null && !this.moves.isEmpty()) {
            sb.append(" moves");
            for (String move : this.moves) {
                sb.append(" ");
                sb.append(move);
            }
        }
        return sb.toString();
    }

    public CmdType getType() {
        return this.type;
    }

    public String getFen() {
        return this.fen;
    }

    public List<String> getMoves() {
        return this.moves;
    }

    public static enum CmdType {
        STARTPOS,
        FEN;

    }
}

