/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.pgn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.chesstango.gardel.fen.FEN;
import net.chesstango.gardel.move.SANDecoder;
import net.chesstango.gardel.pgn.PGN;

public class PGNStringDecoder {
    private static final Pattern headerPattern = Pattern.compile("\\[(\\w*) \"(.*)\"\\]");

    /*
     * Enabled aggressive exception aggregation
     */
    public Stream<PGN> decodePGNs(InputStream inputStream) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            Stream<PGN> stream;
            try (BufferedReader bufferReader = new BufferedReader(inputStreamReader);){
                stream = this.decodePGNs(bufferReader);
            }
            return stream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<PGN> decodePGNs(BufferedReader bufferReader) throws IOException {
        PGN game;
        Stream.Builder<PGN> pgnStreamBuilder = Stream.builder();
        while ((game = this.decodePGN(bufferReader)) != null) {
            pgnStreamBuilder.add(game);
        }
        return pgnStreamBuilder.build();
    }

    public PGN decodePGN(BufferedReader bufferReader) throws IOException {
        PGN pgn = this.decodePGNHeaders(bufferReader);
        if (pgn == null) {
            return null;
        }
        pgn.setMoveList(this.decodePGNBody(bufferReader));
        return pgn;
    }

    protected PGN decodePGNHeaders(BufferedReader bufferReader) throws IOException {
        String line;
        PGN result = new PGN();
        while ((line = bufferReader.readLine()) != null && !"".equals(line.trim())) {
            Matcher headerMather = headerPattern.matcher(line);
            if (!headerMather.find()) continue;
            String headerName = headerMather.group(1).toUpperCase();
            String headerText = headerMather.group(2);
            switch (headerName) {
                case "EVENT": {
                    result.setEvent(headerText);
                    break;
                }
                case "SITE": {
                    result.setSite(headerText);
                    break;
                }
                case "DATE": {
                    result.setDate(headerText);
                    break;
                }
                case "ROUND": {
                    result.setRound(headerText);
                    break;
                }
                case "WHITE": {
                    result.setWhite(headerText);
                    break;
                }
                case "BLACK": {
                    result.setBlack(headerText);
                    break;
                }
                case "FEN": {
                    result.setFen(FEN.of(headerText));
                    break;
                }
                case "RESULT": {
                    result.setResult(switch (headerText) {
                        case "1-0" -> PGN.Result.WHITE_WINS;
                        case "0-1" -> PGN.Result.BLACK_WINS;
                        case "1/2-1/2" -> PGN.Result.DRAW;
                        default -> PGN.Result.ONGOING;
                    });
                }
            }
        }
        if (result.getEvent() == null) {
            return null;
        }
        return result;
    }

    protected List<String> decodePGNBody(BufferedReader bufferReader) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferReader.readLine()) != null && !line.trim().isEmpty()) {
            stringBuilder.append(line.trim());
            stringBuilder.append(" ");
        }
        return this.decodePGNBody(stringBuilder.toString());
    }

    protected List<String> decodePGNBody(String moveListStr) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = SANDecoder.movePattern.matcher(moveListStr);
        while (matcher.find()) {
            String moveStr = matcher.group(0);
            result.add(moveStr);
        }
        return result;
    }
}

