/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.pgn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.chesstango.gardel.epd.EPD;
import net.chesstango.gardel.fen.FEN;
import net.chesstango.gardel.minchess.MinChess;
import net.chesstango.gardel.move.SANDecoder;
import net.chesstango.gardel.pgn.PGNStringEncoder;

public class PGN
implements Serializable {
    private String event;
    private String site;
    private String date;
    private String round;
    private String white;
    private String black;
    private FEN fen;
    private Result result;
    private List<String> moveList;

    public String toString() {
        return new PGNStringEncoder().encode(this);
    }

    public Stream<EPD> toEPD() {
        Stream.Builder<EPD> fenStreamBuilder = Stream.builder();
        MinChess game = MinChess.from(this.getFen() == null ? FEN.of("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1") : this.getFen());
        ArrayList<EPD> epdList = new ArrayList<EPD>(this.getMoveList().size());
        int lastClock = 2;
        SANDecoder<Short> sanDecoder = new SANDecoder<Short>((fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> this.get(game, fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion));
        for (String moveStr : this.getMoveList()) {
            FEN fenGame;
            Short legalMoveToExecute = sanDecoder.decode(moveStr, fenGame = game.toFEN());
            if (legalMoveToExecute != null) {
                EPD epd = new EPD();
                epd.setPiecePlacement(fenGame.getPiecePlacement());
                epd.setActiveColor(fenGame.getActiveColor());
                epd.setCastingsAllowed(fenGame.getCastingsAllowed());
                epd.setEnPassantSquare(fenGame.getEnPassantSquare());
                epd.setId(String.format("%s", Integer.toHexString(fenGame.hashCode())));
                if (this.event != null) {
                    epd.setC0(String.format("event='%s'", this.event));
                }
                if (this.site != null) {
                    epd.setC1(String.format("site='%s'", this.site));
                }
                if (this.date != null) {
                    epd.setC2(String.format("date='%s'", this.date));
                }
                if (this.white != null) {
                    epd.setC3(String.format("white='%s'", this.white));
                }
                if (this.black != null) {
                    epd.setC4(String.format("black='%s'", this.black));
                }
                if (this.result != null) {
                    epd.setC5(String.format("result='%s'", new Object[]{this.result}));
                }
                epd.setC6(String.format("clock=%d", lastClock++ / 2));
                epd.setSuppliedMoveStr(moveStr);
                epdList.add(epd);
                game.doMove(legalMoveToExecute);
                continue;
            }
            throw new RuntimeException(String.format("[%s] %s is not in the list of legal moves for %s", this.getEvent(), moveStr, fenGame.toString()));
        }
        for (EPD epd : epdList) {
            epd.setC7(String.format("totalClock=%d", lastClock - 2));
            fenStreamBuilder.add(epd);
        }
        return fenStreamBuilder.build();
    }

    private Short get(MinChess minchess, int fromFile, int fromRank, int toFile, int toRank, int fromPiece, int toPiece, int promotion) {
        short[] moves = new short[128];
        int size = minchess.generateMoves(moves);
        for (int i = 0; i < size; ++i) {
            short move = moves[i];
            int fromFileFilter = MinChess.fromFile(move);
            int fromRankFilter = MinChess.fromRank(move);
            int fromPieceFilter = minchess.getFromPiece(move);
            int toFileFilter = MinChess.toFile(move);
            int toRankFilter = MinChess.toRank(move);
            int toPieceFilter = minchess.getToPiece(move);
            int promotionFilter = MinChess.getPromotionPiece(move);
            if (fromFile != fromFileFilter || fromRank != fromRankFilter || fromPiece != fromPieceFilter || toFile != toFileFilter || toRank != toRankFilter || toPiece != toPieceFilter || promotion != promotionFilter) continue;
            return move;
        }
        return null;
    }

    public String getEvent() {
        return this.event;
    }

    public String getSite() {
        return this.site;
    }

    public String getDate() {
        return this.date;
    }

    public String getRound() {
        return this.round;
    }

    public String getWhite() {
        return this.white;
    }

    public String getBlack() {
        return this.black;
    }

    public FEN getFen() {
        return this.fen;
    }

    public Result getResult() {
        return this.result;
    }

    public List<String> getMoveList() {
        return this.moveList;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setRound(String round) {
        this.round = round;
    }

    public void setWhite(String white) {
        this.white = white;
    }

    public void setBlack(String black) {
        this.black = black;
    }

    public void setFen(FEN fen) {
        this.fen = fen;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setMoveList(List<String> moveList) {
        this.moveList = moveList;
    }

    public static enum Result {
        WHITE_WINS,
        BLACK_WINS,
        DRAW,
        ONGOING;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "1-0";
                case 1 -> "0-1";
                case 2 -> "1/2-1/2";
                case 3 -> "*";
            };
        }
    }
}

