/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.move;

import java.util.ArrayList;
import net.chesstango.gardel.fen.FEN;
import net.chesstango.gardel.minchess.MinChess;
import net.chesstango.gardel.move.Move;

public class SANEncoder {
    public String encodeAlgebraicNotation(Move move, FEN fen) {
        MinChess minchess = MinChess.from(fen);
        short[] moves = new short[128];
        minchess.generateMoves(moves);
        if (this.moveExists(move, moves)) {
            int fromPiece = minchess.getPiece(move.from().getFile(), move.from().getRank());
            if (fromPiece == 5) {
                return this.encodePawnMove(move, minchess);
            }
            return this.encodePieceMove(move, minchess, moves);
        }
        return null;
    }

    private String encodePawnMove(Move move, MinChess minchess) {
        if (move.from().getFile() == move.to().getFile()) {
            return this.encodePawnPushMove(move, minchess);
        }
        return this.encodePawnCaptureMove(move, minchess);
    }

    private String encodePawnPushMove(Move move, MinChess minchess) {
        if (move.promotionPiece() != null) {
            return String.format("%s=%s", move.to().toString(), this.encodePromotion(move.promotionPiece()));
        }
        return move.to().toString();
    }

    private String encodePawnCaptureMove(Move move, MinChess minchess) {
        if (move.promotionPiece() != null) {
            return String.format("%sx%s=%s", this.fileToLetter(move.from().getFile()), move.to().toString(), this.encodePromotion(move.promotionPiece()));
        }
        return String.format("%sx%s", this.fileToLetter(move.from().getFile()), move.to().toString());
    }

    private String encodePieceMove(Move move, MinChess minchess, short[] moves) {
        int fromPiece = minchess.getPiece(move.from().getFile(), move.from().getRank());
        if (fromPiece == 6) {
            if (move.from().getFile() - move.to().getFile() == 2) {
                return "O-O-O";
            }
            if (move.to().getFile() - move.from().getFile() == 2) {
                return "O-O";
            }
        }
        int toPiece = minchess.getPiece(move.to().getFile(), move.to().getRank());
        String fromPieceStr = switch (fromPiece) {
            case 5 -> "P";
            case 1 -> "N";
            case 2 -> "B";
            case 3 -> "R";
            case 4 -> "Q";
            case 6 -> "K";
            default -> throw new IllegalArgumentException("Invalid piece: " + fromPiece);
        };
        String solvePieceAmbiguityFrom = this.solvePieceAmbiguityFrom(move, minchess, moves);
        String captureStr = toPiece == 0 ? "" : "x";
        return String.format("%s%s%s%s", new Object[]{fromPieceStr, solvePieceAmbiguityFrom, captureStr, move.to()});
    }

    private String solvePieceAmbiguityFrom(Move move, MinChess minchess, short[] moves) {
        int fromPiece = minchess.getPiece(move.from().getFile(), move.from().getRank());
        ArrayList<Short> collisions = new ArrayList<Short>();
        int i = 0;
        while (moves[i] != 0) {
            short theMove = moves[i];
            int toFile = MinChess.toFile(theMove);
            int toRank = MinChess.toRank(theMove);
            int theMovePiece = minchess.getFromPiece(theMove);
            if (theMovePiece == fromPiece && move.to().getFile() == toFile && move.to().getRank() == toRank) {
                collisions.add(theMove);
            }
            ++i;
        }
        if (collisions.size() > 1) {
            long fileCount = collisions.stream().map(MinChess::fromFile).distinct().count();
            long rankCount = collisions.stream().map(MinChess::fromRank).distinct().count();
            if (fileCount == (long)collisions.size()) {
                return this.fileToLetter(move.from().getFile());
            }
            if (rankCount == (long)collisions.size()) {
                return this.rankToLetter(move.from().getRank());
            }
            return Move.Square.of(move.from().getFile(), move.from().getRank()).toString();
        }
        return "";
    }

    private boolean moveExists(Move move, short[] moves) {
        int i = 0;
        while (moves[i] != 0) {
            short theMove = moves[i];
            int fromFile = MinChess.fromFile(theMove);
            int fromRank = MinChess.fromRank(theMove);
            int toFile = MinChess.toFile(theMove);
            int toRank = MinChess.toRank(theMove);
            int promotion = MinChess.getPromotionPiece(theMove);
            if (move.from().getFile() == fromFile && move.from().getRank() == fromRank && move.to().getFile() == toFile && move.to().getRank() == toRank && (promotion == 0 && move.promotionPiece() == null || promotion == 1 && move.promotionPiece() == Move.PromotionPiece.KNIGHT || promotion == 2 && move.promotionPiece() == Move.PromotionPiece.BISHOP || promotion == 3 && move.promotionPiece() == Move.PromotionPiece.ROOK || promotion == 4 && move.promotionPiece() == Move.PromotionPiece.QUEEN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String fileToLetter(int file) {
        return switch (file) {
            case 0 -> "a";
            case 1 -> "b";
            case 2 -> "c";
            case 3 -> "d";
            case 4 -> "e";
            case 5 -> "f";
            case 6 -> "g";
            case 7 -> "h";
            default -> null;
        };
    }

    private String rankToLetter(int rank) {
        return switch (rank) {
            case 0 -> "1";
            case 1 -> "2";
            case 2 -> "3";
            case 3 -> "4";
            case 4 -> "5";
            case 5 -> "6";
            case 6 -> "7";
            case 7 -> "8";
            default -> null;
        };
    }

    private String encodePromotion(Move.PromotionPiece promotionPiece) {
        return switch (promotionPiece) {
            case Move.PromotionPiece.KNIGHT -> "N";
            case Move.PromotionPiece.BISHOP -> "B";
            case Move.PromotionPiece.ROOK -> "R";
            case Move.PromotionPiece.QUEEN -> "Q";
            default -> throw new IllegalArgumentException("Invalid promotion piece: " + String.valueOf((Object)promotionPiece));
        };
    }
}

