/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.move;

import java.lang.runtime.SwitchBootstraps;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.chesstango.gardel.fen.FEN;
import net.chesstango.gardel.minchess.MinChess;
import net.chesstango.gardel.move.Move;
import net.chesstango.gardel.move.MoveDecoder;
import net.chesstango.gardel.move.MovePredicate;
import net.chesstango.gardel.move.MoveSupplier;

public class SANDecoder<M>
implements MoveDecoder<M> {
    public static final Pattern movePattern = Pattern.compile("((?<piecemove>(?<piece>[RNBQK])((?<piecefromfile>[a-h])|(?<piecefromrank>[1-8])|(?<piecefromsquare>[a-h][1-8]))?x?(?<pieceto>[a-h][1-8]))|(?<pawncapture>(?<pawncapturefile>[a-h])[1-8]?x(?<pawncaptureto>[a-h][1-8])=?(?<pawncapturepromotion>[RNBQ]?))|(?<pawnpush>(?<pawnto>[a-h][1-8])=?(?<pawnpushpromotion>[RNBQ]?))|(?<queencaslting>O-O-O)|(?<kingcastling>O-O))[+#]?");
    private final MoveSupplier<M> moveSupplier;

    public SANDecoder(MoveSupplier<M> moveSupplier) {
        this.moveSupplier = moveSupplier;
    }

    @Override
    public M decode(String moveStr, FEN fen) {
        Matcher matcher = movePattern.matcher(moveStr);
        if (matcher.matches()) {
            MinChess minchess = MinChess.from(fen);
            if (matcher.group("piecemove") != null) {
                return this.decodePieceMove(matcher, minchess);
            }
            if (matcher.group("pawnpush") != null) {
                return this.decodePawnPush(matcher, minchess);
            }
            if (matcher.group("pawncapture") != null) {
                return this.decodePawnCapture(matcher, minchess);
            }
            if (matcher.group("queencaslting") != null) {
                return this.searchQueenCastling(minchess);
            }
            if (matcher.group("kingcastling") != null) {
                return this.searchKingCastling(minchess);
            }
        }
        return null;
    }

    private M searchKingCastling(MinChess minchess) {
        MovePredicate moveFilter = (fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> fromPiece == 6 && toFile - fromFile == 2;
        return this.extractMoves(minchess, moveFilter);
    }

    private M searchQueenCastling(MinChess minchess) {
        MovePredicate moveFilter = (fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> fromPiece == 6 && fromFile - toFile == 2;
        return this.extractMoves(minchess, moveFilter);
    }

    private M decodePawnPush(Matcher matcher, MinChess minchess) {
        String pawnTo = matcher.group("pawnto");
        String pawnPushPromotion = matcher.group("pawnpushpromotion");
        Move.Square toSquareFilter = Move.Square.valueOf(pawnTo);
        if ((toSquareFilter.getRank() == 0 || toSquareFilter.getRank() == 7) && pawnPushPromotion.isEmpty()) {
            pawnPushPromotion = "Q";
        }
        int pawnPushPromotionFilter = switch (pawnPushPromotion) {
            case "N" -> 1;
            case "B" -> 2;
            case "R" -> 3;
            case "Q" -> 4;
            default -> 0;
        };
        MovePredicate moveFilter = (fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> {
            Move.Square toSquare;
            return fromPiece == 5 && (toSquare = Move.Square.of(toFile, toRank)) == toSquareFilter && promotion == pawnPushPromotionFilter;
        };
        return this.extractMoves(minchess, moveFilter);
    }

    private M decodePawnCapture(Matcher matcher, MinChess minchess) {
        String pawnCaptureFile = matcher.group("pawncapturefile");
        String pawnCaptureTo = matcher.group("pawncaptureto");
        String pawnCapturePromotion = matcher.group("pawncapturepromotion");
        int pawnCaptureFileInt = SANDecoder.getFileInt(pawnCaptureFile);
        Move.Square toSquareFilter = Move.Square.valueOf(pawnCaptureTo);
        if ((toSquareFilter.getRank() == 0 || toSquareFilter.getRank() == 7) && pawnCapturePromotion.isEmpty()) {
            pawnCapturePromotion = "Q";
        }
        int pawnPushPromotionFilter = switch (pawnCapturePromotion) {
            case "N" -> 1;
            case "B" -> 2;
            case "R" -> 3;
            case "Q" -> 4;
            default -> 0;
        };
        MovePredicate moveFilter = (fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> {
            Move.Square toSquare;
            if (fromPiece == 5 && (toSquare = Move.Square.of(toFile, toRank)) == toSquareFilter && fromFile == pawnCaptureFileInt) {
                return promotion == pawnPushPromotionFilter;
            }
            return false;
        };
        return this.extractMoves(minchess, moveFilter);
    }

    private M decodePieceMove(Matcher matcher, MinChess minchess) {
        String pieceStr = matcher.group("piece");
        String pieceFromFile = matcher.group("piecefromfile");
        String pieceFromRank = matcher.group("piecefromrank");
        String pieceFromSquare = matcher.group("piecefromsquare");
        String pieceTo = matcher.group("pieceto");
        int fromPieceFilter = switch (pieceStr) {
            case "N" -> 1;
            case "B" -> 2;
            case "R" -> 3;
            case "Q" -> 4;
            case "K" -> 6;
            default -> throw new IllegalArgumentException("Invalid piece: " + pieceStr);
        };
        Move.Square pieceToSquare = Move.Square.valueOf(pieceTo);
        int pieceFromFileInt = SANDecoder.getFileInt(pieceFromFile);
        String string = pieceFromRank;
        int n = 0;
        int pieceFromRankInt = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"1", "2", "3", "4", "5", "6", "7", "8"}, (Object)string, n)) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            case 5 -> 5;
            case 6 -> 6;
            case 7 -> 7;
            default -> -1;
        };
        MovePredicate moveFilter = (fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> {
            Move.Square toSquare;
            if (fromPieceFilter == fromPiece && (toSquare = Move.Square.of(toFile, toRank)) == pieceToSquare) {
                return !(pieceFromFileInt != -1 && pieceFromFileInt != fromFile || pieceFromRankInt != -1 && pieceFromRankInt != fromRank);
            }
            return false;
        };
        return this.extractMoves(minchess, moveFilter);
    }

    private static int getFileInt(String pawnCaptureFile) {
        String string = pawnCaptureFile;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"a", "b", "c", "d", "e", "f", "g", "h"}, (Object)string, n)) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            case 5 -> 5;
            case 6 -> 6;
            case 7 -> 7;
            default -> -1;
        };
    }

    private M extractMoves(MinChess minchess, MovePredicate moveFilter) {
        short[] moves = new short[128];
        int size = minchess.generateMoves(moves);
        for (int i = 0; i < size; ++i) {
            int promotion;
            int toPiece;
            int fromPiece;
            int toRank;
            int toFile;
            int fromRank;
            short move = moves[i];
            int fromFile = MinChess.fromFile(move);
            if (!moveFilter.test(fromFile, fromRank = MinChess.fromRank(move), toFile = MinChess.toFile(move), toRank = MinChess.toRank(move), fromPiece = minchess.getFromPiece(move), toPiece = minchess.getToPiece(move), promotion = MinChess.getPromotionPiece(move))) continue;
            return this.moveSupplier.get(fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion);
        }
        return null;
    }
}

