/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.move;

import net.chesstango.gardel.move.MoveSupplier;

public record Move(Square from, Square to, PromotionPiece promotionPiece) {
    public static Move of(Square from, Square to) {
        return Move.of(from, to, null);
    }

    public static Move of(Square from, Square to, PromotionPiece promotionPiece) {
        return new Move(from, to, promotionPiece);
    }

    public static Move of(String moveStr) {
        if (moveStr.length() < 4 || moveStr.length() > 5) {
            throw new IllegalArgumentException(String.format("Move string must be of length 4, but was %d", moveStr.length()));
        }
        Square from = Square.valueOf(moveStr.substring(0, 2));
        Square to = Square.valueOf(moveStr.substring(2, 4));
        PromotionPiece promotionPiece = moveStr.length() == 5 ? PromotionPiece.from(moveStr.substring(4, 5)) : null;
        return new Move(from, to, promotionPiece);
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", this.from.toString(), this.to.toString(), this.promotionPiece == null ? "" : this.promotionPiece.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Move that = (Move)o;
        return this.from == that.from && this.to == that.to && this.promotionPiece == that.promotionPiece;
    }

    public static enum Square {
        a8(0, 7),
        b8(1, 7),
        c8(2, 7),
        d8(3, 7),
        e8(4, 7),
        f8(5, 7),
        g8(6, 7),
        h8(7, 7),
        a7(0, 6),
        b7(1, 6),
        c7(2, 6),
        d7(3, 6),
        e7(4, 6),
        f7(5, 6),
        g7(6, 6),
        h7(7, 6),
        a6(0, 5),
        b6(1, 5),
        c6(2, 5),
        d6(3, 5),
        e6(4, 5),
        f6(5, 5),
        g6(6, 5),
        h6(7, 5),
        a5(0, 4),
        b5(1, 4),
        c5(2, 4),
        d5(3, 4),
        e5(4, 4),
        f5(5, 4),
        g5(6, 4),
        h5(7, 4),
        a4(0, 3),
        b4(1, 3),
        c4(2, 3),
        d4(3, 3),
        e4(4, 3),
        f4(5, 3),
        g4(6, 3),
        h4(7, 3),
        a3(0, 2),
        b3(1, 2),
        c3(2, 2),
        d3(3, 2),
        e3(4, 2),
        f3(5, 2),
        g3(6, 2),
        h3(7, 2),
        a2(0, 1),
        b2(1, 1),
        c2(2, 1),
        d2(3, 1),
        e2(4, 1),
        f2(5, 1),
        g2(6, 1),
        h2(7, 1),
        a1(0, 0),
        b1(1, 0),
        c1(2, 0),
        d1(3, 0),
        e1(4, 0),
        f1(5, 0),
        g1(6, 0),
        h1(7, 0);

        private static final Square[] array;
        private final int file;
        private final int rank;

        private Square(int file, int rank) {
            this.file = file;
            this.rank = rank;
        }

        public static Square of(int file, int rank) {
            if (file < 0 || rank < 0) {
                return null;
            }
            if (file > 7 || rank > 7) {
                return null;
            }
            return array[rank * 8 + file];
        }

        public static Square of(int idx) {
            return Square.of(idx % 8, idx / 8);
        }

        public int getFile() {
            return this.file;
        }

        public int getRank() {
            return this.rank;
        }

        static {
            array = new Square[]{a1, b1, c1, d1, e1, f1, g1, h1, a2, b2, c2, d2, e2, f2, g2, h2, a3, b3, c3, d3, e3, f3, g3, h3, a4, b4, c4, d4, e4, f4, g4, h4, a5, b5, c5, d5, e5, f5, g5, h5, a6, b6, c6, d6, e6, f6, g6, h6, a7, b7, c7, d7, e7, f7, g7, h7, a8, b8, c8, d8, e8, f8, g8, h8};
        }
    }

    public static enum PromotionPiece {
        KNIGHT,
        BISHOP,
        ROOK,
        QUEEN;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "n";
                case 1 -> "b";
                case 2 -> "r";
                case 3 -> "w";
            };
        }

        static PromotionPiece from(String promotionStr) {
            if (promotionStr == null) {
                return null;
            }
            return switch (promotionStr.toLowerCase()) {
                case "n" -> KNIGHT;
                case "b" -> BISHOP;
                case "r" -> ROOK;
                case "q" -> QUEEN;
                default -> throw new IllegalArgumentException(String.format("Promotion piece must be one of the following: n, b, r, q, but was %s", promotionStr));
            };
        }
    }

    public static class GardelMoveSupplier
    implements MoveSupplier<Move> {
        @Override
        public Move get(int fromFile, int fromRank, int toFile, int toRank, int fromPiece, int toPiece, int promotion) {
            Square fromSquare = Square.of(fromFile, fromRank);
            Square toSquare = Square.of(toFile, toRank);
            PromotionPiece promotionPieceEnum = GardelMoveSupplier.toMovePromotion(promotion);
            return new Move(fromSquare, toSquare, promotionPieceEnum);
        }

        private static PromotionPiece toMovePromotion(int promotionPiece) {
            return switch (promotionPiece) {
                case 1 -> PromotionPiece.KNIGHT;
                case 2 -> PromotionPiece.BISHOP;
                case 3 -> PromotionPiece.ROOK;
                case 4 -> PromotionPiece.QUEEN;
                default -> null;
            };
        }
    }
}

