/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.move;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.chesstango.gardel.fen.FEN;
import net.chesstango.gardel.minchess.MinChess;
import net.chesstango.gardel.move.Move;
import net.chesstango.gardel.move.MoveDecoder;
import net.chesstango.gardel.move.MovePredicate;
import net.chesstango.gardel.move.MoveSupplier;

public class LANDecoder<M>
implements MoveDecoder<M> {
    private static final Pattern edpMovePattern = Pattern.compile("((?<piecemove>(?<piece>[RNBQK])(?<from>[a-h][1-8])[-x]?(?<to>[a-h][1-8]))|(?<pawnmove>(?<pawnfrom>[a-h][1-8])[-x](?<pawnto>[a-h][1-8])(?<promotionpiece>[RNBQK])?))[+#]?");
    private final MoveSupplier<M> moveSupplier;

    public LANDecoder(MoveSupplier<M> moveSupplier) {
        this.moveSupplier = moveSupplier;
    }

    @Override
    public M decode(String moveStr, FEN fen) {
        Matcher matcher = edpMovePattern.matcher(moveStr);
        if (matcher.matches()) {
            MinChess minchess = MinChess.from(fen);
            if (matcher.group("piecemove") != null) {
                return this.decodePieceMove(matcher, minchess);
            }
            if (matcher.group("pawnmove") != null) {
                return this.decodePawnMove(matcher, minchess);
            }
        }
        return null;
    }

    private M decodePieceMove(Matcher matcher, MinChess minchess) {
        String pieceStr = matcher.group("piece");
        String fromStr = matcher.group("from");
        String toStr = matcher.group("to");
        Move.Square fromSquareFilter = Move.Square.valueOf(fromStr);
        Move.Square toSquareFilter = Move.Square.valueOf(toStr);
        int pieceFilter = switch (pieceStr) {
            case "N" -> 1;
            case "B" -> 2;
            case "R" -> 3;
            case "Q" -> 4;
            case "K" -> 6;
            default -> -1;
        };
        MovePredicate moveFilter = (fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> {
            Move.Square fromSquare = Move.Square.of(fromFile, fromRank);
            Move.Square toSquare = Move.Square.of(toFile, toRank);
            return fromPiece == pieceFilter && fromSquareFilter.equals((Object)fromSquare) && toSquareFilter.equals((Object)toSquare);
        };
        return this.extractMoves(minchess, moveFilter);
    }

    private M decodePawnMove(Matcher matcher, MinChess minchess) {
        String fromStr = matcher.group("pawnfrom");
        String toStr = matcher.group("pawnto");
        String promotionPieceStr = matcher.group("promotionpiece");
        Move.Square fromSquareFilter = Move.Square.valueOf(fromStr);
        Move.Square toSquareFilter = Move.Square.valueOf(toStr);
        Move.PromotionPiece promotionPieceFilter = Move.PromotionPiece.from(promotionPieceStr);
        MovePredicate moveFilter = (fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion) -> {
            Move.Square fromSquare = Move.Square.of(fromFile, fromRank);
            Move.Square toSquare = Move.Square.of(toFile, toRank);
            Move.PromotionPiece promotionPiece = LANDecoder.toMovePromotion(promotion);
            return fromPiece == 5 && fromSquareFilter.equals((Object)fromSquare) && toSquareFilter.equals((Object)toSquare) && Objects.equals((Object)promotionPieceFilter, (Object)promotionPiece);
        };
        return this.extractMoves(minchess, moveFilter);
    }

    private M extractMoves(MinChess minchess, MovePredicate moveFilter) {
        short[] moves = new short[128];
        int size = minchess.generateMoves(moves);
        for (int i = 0; i < size; ++i) {
            int promotion;
            int toPiece;
            int fromPiece;
            int toRank;
            int toFile;
            int fromRank;
            short move = moves[i];
            int fromFile = MinChess.fromFile(move);
            if (!moveFilter.test(fromFile, fromRank = MinChess.fromRank(move), toFile = MinChess.toFile(move), toRank = MinChess.toRank(move), fromPiece = minchess.getFromPiece(move), toPiece = minchess.getToPiece(move), promotion = MinChess.getPromotionPiece(move))) continue;
            return this.moveSupplier.get(fromFile, fromRank, toFile, toRank, fromPiece, toPiece, promotion);
        }
        return null;
    }

    private static Move.PromotionPiece toMovePromotion(int promotionPiece) {
        return switch (promotionPiece) {
            case 1 -> Move.PromotionPiece.KNIGHT;
            case 2 -> Move.PromotionPiece.BISHOP;
            case 3 -> Move.PromotionPiece.ROOK;
            case 4 -> Move.PromotionPiece.QUEEN;
            default -> null;
        };
    }
}

