/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import java.util.function.BiPredicate;
import net.chesstango.gardel.minchess.AbstractPiece;
import net.chesstango.gardel.minchess.MinChessConstants;
import net.chesstango.gardel.minchess.MinChessWorkspace;

class Rook
extends AbstractPiece {
    Rook(BiPredicate<Long, Long> isLegalMoveFn) {
        super(isLegalMoveFn);
    }

    @Override
    int generateMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        long from;
        int size = 0;
        for (long fromRooks = (workspace.rookPositions | workspace.queenPositions) & (workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions); fromRooks != 0L; fromRooks &= from ^ 0xFFFFFFFFFFFFFFFFL) {
            from = 1L << Long.numberOfTrailingZeros(fromRooks);
            size += this.generateRookMovesNorth(workspace, moves, startIdx + size, from);
            size += this.generateRookMovesSouth(workspace, moves, startIdx + size, from);
            size += this.generateRookMovesEast(workspace, moves, startIdx + size, from);
            size += this.generateRookMovesWest(workspace, moves, startIdx + size, from);
        }
        return size;
    }

    int generateRookMovesWest(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0x101010101010101L) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition >>>= 1) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0x101010101010101L) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    int generateRookMovesEast(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0x8080808080808080L) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition <<= 1) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0x8080808080808080L) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    int generateRookMovesNorth(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0xFF00000000000000L) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition <<= 8) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0xFF00000000000000L) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    int generateRookMovesSouth(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0xFFL) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition >>>= 8) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0xFFL) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    @Override
    boolean isKingInCheckByOpponent(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        return this.isKingInCheckByOpponentRookNorth(workspace, kingPosition, kingIdx, opponentColor) || this.isKingInCheckByOpponentRookSouth(workspace, kingPosition, kingIdx, opponentColor) || this.isKingInCheckByOpponentRookEast(workspace, kingPosition, kingIdx, opponentColor) || this.isKingInCheckByOpponentRookWest(workspace, kingPosition, kingIdx, opponentColor);
    }

    boolean isKingInCheckByOpponentRookWest(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentRooks = (workspace.rookPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0x101010101010101L) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition >>>= 1) & opponentRooks) == 0L) continue;
                return true;
            } while ((toPosition & 0x101010101010101L) == 0L && (toPosition & emptyPositions) != 0L);
        }
        return false;
    }

    boolean isKingInCheckByOpponentRookEast(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentRooks = (workspace.rookPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0x8080808080808080L) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition <<= 1) & opponentRooks) == 0L) continue;
                return true;
            } while ((toPosition & 0x8080808080808080L) == 0L && (toPosition & emptyPositions) != 0L);
        }
        return false;
    }

    boolean isKingInCheckByOpponentRookNorth(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentRooks = (workspace.rookPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0xFF00000000000000L) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition <<= 8) & opponentRooks) == 0L) continue;
                return true;
            } while ((toPosition & 0xFF00000000000000L) == 0L && (toPosition & emptyPositions) != 0L);
        }
        return false;
    }

    boolean isKingInCheckByOpponentRookSouth(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long opponentRooks = (workspace.rookPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0xFFL) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition >>>= 8) & opponentRooks) == 0L) continue;
                return true;
            } while ((toPosition & 0xFFL) == 0L && (toPosition & allPositions) == 0L);
        }
        return false;
    }
}

