/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import java.util.function.BiPredicate;
import net.chesstango.gardel.minchess.AbstractPiece;
import net.chesstango.gardel.minchess.MinChessConstants;
import net.chesstango.gardel.minchess.MinChessWorkspace;

class PawnWhite
extends AbstractPiece {
    static final long START_POS = 65280L;
    final BiPredicate<Long, Long> isLegalEnPassantMoveFn;

    PawnWhite(BiPredicate<Long, Long> isLegalMoveFn, BiPredicate<Long, Long> isLegalEnPassantMoveFn) {
        super(isLegalMoveFn);
        this.isLegalEnPassantMoveFn = isLegalEnPassantMoveFn;
    }

    @Override
    int generateMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        long from;
        int size = 0;
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentPositions = workspace.blackPositions;
        for (long fromPawns = workspace.pawnPositions & workspace.whitePositions; fromPawns != 0L; fromPawns &= from ^ 0xFFFFFFFFFFFFFFFFL) {
            from = 1L << Long.numberOfTrailingZeros(fromPawns);
            size += this.generateMoveForward(moves, startIdx + size, from, emptyPositions);
            size += this.generateDoubleMoveForward(moves, startIdx + size, from, emptyPositions);
            size += this.generateCaptureMove(moves, startIdx + size, from, opponentPositions);
            size += this.generateCaptureEnPassantMove(workspace.enPassantSquare, moves, startIdx + size, from);
        }
        return size;
    }

    int generateCaptureEnPassantMove(long enPassantSquare, short[] moves, int startIdx, long from) {
        int size = 0;
        if (enPassantSquare != 0L) {
            long toPosition;
            if ((from & 0x8080808080808080L) == 0L && ((toPosition = from << 9) & enPassantSquare) != 0L && this.isLegalEnPassantMoveFn.test(from, enPassantSquare)) {
                moves[startIdx + size++] = MinChessConstants.encodeMove(from, toPosition);
            }
            if ((from & 0x101010101010101L) == 0L && ((toPosition = from << 7) & enPassantSquare) != 0L && this.isLegalEnPassantMoveFn.test(from, enPassantSquare)) {
                size = this.createMove(moves, startIdx, from, toPosition);
            }
        }
        return size;
    }

    int generateCaptureMove(short[] moves, int startIdx, long from, long opponentPositions) {
        int size = 0;
        size += this.generateCaptureNorthEast(moves, startIdx + size, from, opponentPositions);
        size += this.generateCaptureNorthWest(moves, startIdx + size, from, opponentPositions);
        return size;
    }

    int generateCaptureNorthEast(short[] moves, int startIdx, long from, long opponentPositions) {
        long toPosition;
        int size = 0;
        if ((from & 0x8080808080808080L) == 0L && ((toPosition = from << 9) & opponentPositions) != 0L && this.isLegalMoveFn.test(from, toPosition)) {
            size = this.createMove(moves, startIdx, from, toPosition);
        }
        return size;
    }

    int generateCaptureNorthWest(short[] moves, int startIdx, long from, long opponentPositions) {
        long toPosition;
        int size = 0;
        if ((from & 0x101010101010101L) == 0L && ((toPosition = from << 7) & opponentPositions) != 0L && this.isLegalMoveFn.test(from, toPosition)) {
            size = this.createMove(moves, startIdx, from, toPosition);
        }
        return size;
    }

    int generateMoveForward(short[] moves, int startIdx, long from, long emptyPositions) {
        int size = 0;
        long to = from << 8;
        if ((to & emptyPositions) != 0L && this.isLegalMoveFn.test(from, to)) {
            size = this.createMove(moves, startIdx, from, to);
        }
        return size;
    }

    int generateDoubleMoveForward(short[] moves, int startIdx, long from, long emptyPositions) {
        long to;
        long intermediate;
        int size = 0;
        if ((from & 0xFF00L) != 0L && ((intermediate = from << 8) & emptyPositions) != 0L && ((to = intermediate << 8) & emptyPositions) != 0L && this.isLegalMoveFn.test(from, to)) {
            moves[startIdx + size++] = MinChessConstants.encodeMove(from, to);
        }
        return size;
    }

    int createMove(short[] moves, int startIdx, long from, long to) {
        int size = 0;
        if ((to & 0xFF00000000000000L) != 0L) {
            moves[startIdx + size++] = MinChessConstants.encodeMove(from, to, 1);
            moves[startIdx + size++] = MinChessConstants.encodeMove(from, to, 2);
            moves[startIdx + size++] = MinChessConstants.encodeMove(from, to, 3);
            moves[startIdx + size++] = MinChessConstants.encodeMove(from, to, 4);
        } else {
            moves[startIdx + size++] = MinChessConstants.encodeMove(from, to);
        }
        return size;
    }

    @Override
    boolean isKingInCheckByOpponent(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long pawnPosition;
        long whitePawns = workspace.whitePositions & workspace.pawnPositions;
        if ((kingPosition & 0x1010101010101FFL) == 0L && (whitePawns & (pawnPosition = kingPosition >>> 9)) != 0L) {
            return true;
        }
        return (kingPosition & 0x80808080808080FFL) == 0L && (whitePawns & (pawnPosition = kingPosition >>> 7)) != 0L;
    }
}

