/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import java.util.function.BiPredicate;
import net.chesstango.gardel.minchess.MinChessWorkspace;
import net.chesstango.gardel.minchess.PawnBlack;
import net.chesstango.gardel.minchess.PawnWhite;

class Pawn {
    final PawnWhite pawnWhite;
    final PawnBlack pawnBlack;

    Pawn(BiPredicate<Long, Long> isLegalMoveFn, BiPredicate<Long, Long> isLegalEnPassantMoveFn) {
        this.pawnWhite = new PawnWhite(isLegalMoveFn, isLegalEnPassantMoveFn);
        this.pawnBlack = new PawnBlack(isLegalMoveFn, isLegalEnPassantMoveFn);
    }

    int generatePawnMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        return workspace.whiteTurn ? this.pawnWhite.generateMoves(workspace, moves, startIdx) : this.pawnBlack.generateMoves(workspace, moves, startIdx);
    }

    boolean isKingInCheckByOpponentPawn(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        return opponentColor ? this.pawnWhite.isKingInCheckByOpponent(workspace, kingPosition, kingIdx, opponentColor) : this.pawnBlack.isKingInCheckByOpponent(workspace, kingPosition, kingIdx, opponentColor);
    }
}

