/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import net.chesstango.gardel.minchess.MinChess;

class MinChessWorkspace {
    boolean whiteTurn;
    boolean castlingBlackKingAllowed;
    boolean castlingBlackQueenAllowed;
    boolean castlingWhiteKingAllowed;
    boolean castlingWhiteQueenAllowed;
    long enPassantSquare = 0L;
    long whitePositions = 0L;
    long blackPositions = 0L;
    long kingPositions = 0L;
    long queenPositions = 0L;
    long rookPositions = 0L;
    long bishopPositions = 0L;
    long knightPositions = 0L;
    long pawnPositions = 0L;
    final MinChess minChess;

    MinChessWorkspace(boolean whiteTurn, boolean castlingBlackKingAllowed, boolean castlingBlackQueenAllowed, boolean castlingWhiteKingAllowed, boolean castlingWhiteQueenAllowed, long enPassantSquare, long whitePositions, long blackPositions, long kingPositions, long queenPositions, long rookPositions, long bishopPositions, long knightPositions, long pawnPositions, MinChess minChess) {
        this.whiteTurn = whiteTurn;
        this.castlingBlackKingAllowed = castlingBlackKingAllowed;
        this.castlingBlackQueenAllowed = castlingBlackQueenAllowed;
        this.castlingWhiteKingAllowed = castlingWhiteKingAllowed;
        this.castlingWhiteQueenAllowed = castlingWhiteQueenAllowed;
        this.enPassantSquare = enPassantSquare;
        this.whitePositions = whitePositions;
        this.blackPositions = blackPositions;
        this.kingPositions = kingPositions;
        this.queenPositions = queenPositions;
        this.rookPositions = rookPositions;
        this.bishopPositions = bishopPositions;
        this.knightPositions = knightPositions;
        this.pawnPositions = pawnPositions;
        this.minChess = minChess;
    }

    MinChessWorkspace(MinChess minChess) {
        this.minChess = minChess;
    }

    void copyFrom(MinChessWorkspace other) {
        this.whiteTurn = other.whiteTurn;
        this.castlingBlackKingAllowed = other.castlingBlackKingAllowed;
        this.castlingBlackQueenAllowed = other.castlingBlackQueenAllowed;
        this.castlingWhiteKingAllowed = other.castlingWhiteKingAllowed;
        this.castlingWhiteQueenAllowed = other.castlingWhiteQueenAllowed;
        this.enPassantSquare = other.enPassantSquare;
        this.whitePositions = other.whitePositions;
        this.blackPositions = other.blackPositions;
        this.kingPositions = other.kingPositions;
        this.queenPositions = other.queenPositions;
        this.rookPositions = other.rookPositions;
        this.bishopPositions = other.bishopPositions;
        this.knightPositions = other.knightPositions;
        this.pawnPositions = other.pawnPositions;
    }

    void doMoveImp(long from, long to) {
        if ((to & this.whitePositions) != 0L || (to & this.blackPositions) != 0L) {
            if ((to & this.queenPositions) != 0L) {
                this.queenPositions &= to ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((to & this.rookPositions) != 0L) {
                this.rookPositions &= to ^ 0xFFFFFFFFFFFFFFFFL;
                if (to == 1L) {
                    this.castlingWhiteQueenAllowed = false;
                } else if (to == 128L) {
                    this.castlingWhiteKingAllowed = false;
                } else if (to == 0x100000000000000L) {
                    this.castlingBlackQueenAllowed = false;
                } else if (to == Long.MIN_VALUE) {
                    this.castlingBlackKingAllowed = false;
                }
            }
            if ((to & this.bishopPositions) != 0L) {
                this.bishopPositions &= to ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((to & this.knightPositions) != 0L) {
                this.knightPositions &= to ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if ((to & this.pawnPositions) != 0L) {
                this.pawnPositions &= to ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (this.whiteTurn) {
                this.blackPositions &= to ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                this.whitePositions &= to ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if ((from & this.kingPositions) != 0L) {
            this.kingPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.kingPositions |= to;
            if (from == 16L) {
                this.castlingWhiteKingAllowed = false;
                this.castlingWhiteQueenAllowed = false;
            } else if (from == 0x1000000000000000L) {
                this.castlingBlackKingAllowed = false;
                this.castlingBlackQueenAllowed = false;
            }
        }
        if ((from & this.queenPositions) != 0L) {
            this.queenPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.queenPositions |= to;
        }
        if ((from & this.rookPositions) != 0L) {
            this.rookPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.rookPositions |= to;
            if (from == 1L) {
                this.castlingWhiteQueenAllowed = false;
            } else if (from == 128L) {
                this.castlingWhiteKingAllowed = false;
            } else if (from == 0x100000000000000L) {
                this.castlingBlackQueenAllowed = false;
            } else if (from == Long.MIN_VALUE) {
                this.castlingBlackKingAllowed = false;
            }
        }
        if ((from & this.bishopPositions) != 0L) {
            this.bishopPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.bishopPositions |= to;
        }
        if ((from & this.knightPositions) != 0L) {
            this.knightPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.knightPositions |= to;
        }
        if ((from & this.pawnPositions) != 0L) {
            this.pawnPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.pawnPositions |= to;
        }
        this.enPassantSquare = 0L;
        if (this.whiteTurn) {
            this.whitePositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.whitePositions |= to;
        } else {
            this.blackPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
            this.blackPositions |= to;
        }
        this.whiteTurn = !this.whiteTurn;
    }

    void doMovePromotionImp(long from, long to, int promotionPiece) {
        this.pawnPositions &= from ^ 0xFFFFFFFFFFFFFFFFL;
        switch (promotionPiece) {
            case 1: {
                this.knightPositions |= from;
                break;
            }
            case 2: {
                this.bishopPositions |= from;
                break;
            }
            case 3: {
                this.rookPositions |= from;
                break;
            }
            case 4: {
                this.queenPositions |= from;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid promotion piece: " + promotionPiece);
            }
        }
        this.doMoveImp(from, to);
    }

    void doEnPassantMoveImp(long from, long enPassantSquare) {
        if (this.whiteTurn) {
            long enPassantPawn = enPassantSquare >>> 8;
            this.blackPositions &= enPassantPawn ^ 0xFFFFFFFFFFFFFFFFL;
            this.pawnPositions &= enPassantPawn ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            long enPassantPawn = enPassantSquare << 8;
            this.whitePositions &= enPassantPawn ^ 0xFFFFFFFFFFFFFFFFL;
            this.pawnPositions &= enPassantPawn ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.doMoveImp(from, enPassantSquare);
    }

    void doCastlingMoveImp(long from, long to) {
        if (this.whiteTurn) {
            if (from == 16L && to == 64L) {
                this.rookPositions &= 0xFFFFFFFFFFFFFF7FL;
                this.rookPositions |= 0x20L;
                this.whitePositions &= 0xFFFFFFFFFFFFFF7FL;
                this.whitePositions |= 0x20L;
            } else if (from == 16L && to == 4L) {
                this.rookPositions &= 0xFFFFFFFFFFFFFFFEL;
                this.rookPositions |= 8L;
                this.whitePositions &= 0xFFFFFFFFFFFFFFFEL;
                this.whitePositions |= 8L;
            } else {
                throw new RuntimeException("Error");
            }
            this.castlingWhiteKingAllowed = false;
            this.castlingWhiteQueenAllowed = false;
        } else {
            if (from == 0x1000000000000000L && to == 0x4000000000000000L) {
                this.rookPositions &= Long.MAX_VALUE;
                this.rookPositions |= 0x2000000000000000L;
                this.blackPositions &= Long.MAX_VALUE;
                this.blackPositions |= 0x2000000000000000L;
            } else if (from == 0x1000000000000000L && to == 0x400000000000000L) {
                this.rookPositions &= 0xFEFFFFFFFFFFFFFFL;
                this.rookPositions |= 0x800000000000000L;
                this.blackPositions &= 0xFEFFFFFFFFFFFFFFL;
                this.blackPositions |= 0x800000000000000L;
            } else {
                throw new RuntimeException("Error");
            }
            this.castlingBlackKingAllowed = false;
            this.castlingBlackQueenAllowed = false;
        }
        this.doMoveImp(from, to);
    }

    boolean isKingInCheck(boolean turn) {
        return this.minChess.isKingInCheck(this, turn);
    }

    void validate() {
        if ((this.whitePositions & this.blackPositions) != 0L) {
            throw new RuntimeException("White and Black positions collide");
        }
        long allPositions = this.whitePositions | this.blackPositions;
        if ((allPositions & this.kingPositions) != this.kingPositions) {
            throw new RuntimeException("King positions don't match");
        }
        if (((allPositions &= this.kingPositions ^ 0xFFFFFFFFFFFFFFFFL) & this.queenPositions) != this.queenPositions) {
            throw new RuntimeException("Queen positions don't match");
        }
        if (((allPositions &= this.queenPositions ^ 0xFFFFFFFFFFFFFFFFL) & this.rookPositions) != this.rookPositions) {
            throw new RuntimeException("Rook positions don't match");
        }
        if (((allPositions &= this.rookPositions ^ 0xFFFFFFFFFFFFFFFFL) & this.bishopPositions) != this.bishopPositions) {
            throw new RuntimeException("Bishop positions don't match");
        }
        if (((allPositions &= this.bishopPositions ^ 0xFFFFFFFFFFFFFFFFL) & this.knightPositions) != this.knightPositions) {
            throw new RuntimeException("Knight positions don't match");
        }
        if (((allPositions &= this.knightPositions ^ 0xFFFFFFFFFFFFFFFFL) & this.pawnPositions) != this.pawnPositions) {
            throw new RuntimeException("Pawn positions don't match");
        }
        if ((allPositions &= this.pawnPositions ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
            throw new RuntimeException("All positions don't match");
        }
    }
}

