/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import java.util.function.BiConsumer;
import net.chesstango.gardel.PositionBuilder;
import net.chesstango.gardel.minchess.MinChess;
import net.chesstango.gardel.minchess.MinChessWorkspace;

public class MinChessExporter {
    private final PositionBuilder<?> positionBuilder;

    public MinChessExporter(PositionBuilder<?> positionBuilder) {
        this.positionBuilder = positionBuilder;
    }

    public void export(MinChess minChess) {
        MinChessWorkspace workspace = minChess.workspace;
        this.positionBuilder.withWhiteTurn(workspace.whiteTurn);
        this.positionBuilder.withCastlingBlackKingAllowed(workspace.castlingBlackKingAllowed);
        this.positionBuilder.withCastlingBlackQueenAllowed(workspace.castlingBlackQueenAllowed);
        this.positionBuilder.withCastlingWhiteKingAllowed(workspace.castlingWhiteKingAllowed);
        this.positionBuilder.withCastlingWhiteQueenAllowed(workspace.castlingWhiteQueenAllowed);
        if (workspace.enPassantSquare != 0L) {
            int enPassantSquareIdx = Long.numberOfTrailingZeros(workspace.enPassantSquare);
            int file = enPassantSquareIdx / 8;
            int rank = enPassantSquareIdx % 8;
            this.positionBuilder.withEnPassantSquare(file, rank);
        }
        this.setPosition(workspace.whitePositions & workspace.pawnPositions, this.positionBuilder::withWhitePawn);
        this.setPosition(workspace.whitePositions & workspace.knightPositions, this.positionBuilder::withWhiteKnight);
        this.setPosition(workspace.whitePositions & workspace.bishopPositions, this.positionBuilder::withWhiteBishop);
        this.setPosition(workspace.whitePositions & workspace.rookPositions, this.positionBuilder::withWhiteRook);
        this.setPosition(workspace.whitePositions & workspace.queenPositions, this.positionBuilder::withWhiteQueen);
        this.setPosition(workspace.whitePositions & workspace.kingPositions, this.positionBuilder::withWhiteKing);
        this.setPosition(workspace.blackPositions & workspace.pawnPositions, this.positionBuilder::withBlackPawn);
        this.setPosition(workspace.blackPositions & workspace.knightPositions, this.positionBuilder::withBlackKnight);
        this.setPosition(workspace.blackPositions & workspace.bishopPositions, this.positionBuilder::withBlackBishop);
        this.setPosition(workspace.blackPositions & workspace.rookPositions, this.positionBuilder::withBlackRook);
        this.setPosition(workspace.blackPositions & workspace.queenPositions, this.positionBuilder::withBlackQueen);
        this.setPosition(workspace.blackPositions & workspace.kingPositions, this.positionBuilder::withBlackKing);
    }

    void setPosition(long position, BiConsumer<Integer, Integer> setPositionFn) {
        while (position != 0L) {
            int idx = Long.numberOfTrailingZeros(position);
            int file = idx % 8;
            int rank = idx / 8;
            setPositionFn.accept(file, rank);
            position &= 1L << idx ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }
}

