/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

class MinChessConstants {
    static final long A1 = 1L;
    static final long C1 = 4L;
    static final long D1 = 8L;
    static final long E1 = 16L;
    static final long F1 = 32L;
    static final long G1 = 64L;
    static final long H1 = 128L;
    static final long A8 = 0x100000000000000L;
    static final long C8 = 0x400000000000000L;
    static final long D8 = 0x800000000000000L;
    static final long E8 = 0x1000000000000000L;
    static final long F8 = 0x2000000000000000L;
    static final long G8 = 0x4000000000000000L;
    static final long H8 = Long.MIN_VALUE;
    static final long LIMIT_NORTH = -72057594037927936L;
    static final long LIMIT_SOUTH = 255L;
    static final long LIMIT_EAST = -9187201950435737472L;
    static final long LIMIT_WEST = 0x101010101010101L;
    static final long LIMIT_NORTH_EAST = -35887507618889600L;
    static final long LIMIT_NORTH_WEST = -71775015237779199L;
    static final long LIMIT_SOUTH_EAST = -9187201950435737345L;
    static final long LIMIT_SOUTH_WEST = 0x1010101010101FFL;
    static final long[] KING_JUMPS = new long[]{770L, 1797L, 3594L, 7188L, 14376L, 28752L, 57504L, 49216L, 197123L, 460039L, 920078L, 0x1C141CL, 0x382838L, 0x705070L, 0xE0A0E0L, 0xC040C0L, 0x3020300L, 0x7050700L, 0xE0A0E00L, 471079936L, 942159872L, 0x70507000L, 0xE0A0E000L, 0xC040C000L, 0x302030000L, 0x705070000L, 0xE0A0E0000L, 120596463616L, 241192927232L, 0x7050700000L, 0xE0A0E00000L, 0xC040C00000L, 0x30203000000L, 0x70507000000L, 0xE0A0E000000L, 30872694685696L, 61745389371392L, 0x705070000000L, 0xE0A0E0000000L, 0xC040C0000000L, 0x3020300000000L, 0x7050700000000L, 0xE0A0E00000000L, 7903409839538176L, 15806819679076352L, 0x70507000000000L, 0xE0A0E000000000L, 0xC040C000000000L, 0x302030000000000L, 0x705070000000000L, 0xE0A0E0000000000L, 2023272918921773056L, 4046545837843546112L, 0x7050700000000000L, -2260560722335367168L, -4593460513685372928L, 0x203000000000000L, 0x507000000000000L, 0xA0E000000000000L, 1449033180106457088L, 2898066360212914176L, 0x5070000000000000L, -6854478632857894912L, 0x40C0000000000000L};
    static final long[] KNIGHT_JUMPS = new long[]{132096L, 329728L, 659712L, 1319424L, 2638848L, 0x508800L, 0xA01000L, 0x402000L, 0x2040004L, 0x5080008L, 0xA110011L, 337772578L, 675545156L, 0x50880088L, 0xA0100010L, 0x40200020L, 0x204000402L, 0x508000805L, 0xA1100110AL, 86469779988L, 172939559976L, 0x5088008850L, 0xA0100010A0L, 0x4020002040L, 0x20400040200L, 0x50800080500L, 0xA1100110A00L, 22136263676928L, 44272527353856L, 0x508800885000L, 0xA0100010A000L, 0x402000204000L, 0x2040004020000L, 0x5080008050000L, 0xA1100110A0000L, 5666883501293568L, 11333767002587136L, 0x50880088500000L, 0xA0100010A00000L, 0x40200020400000L, 0x204000402000000L, 0x508000805000000L, 0xA1100110A000000L, 1450722176331153408L, 2901444352662306816L, 0x5088008850000000L, -6913025356609880064L, 0x4020002040000000L, 0x400040200000000L, 0x800080500000000L, 0x1100110A00000000L, 2449995666584240128L, 4899991333168480256L, -8646761407372591104L, 0x100010A000000000L, 0x2000204000000000L, 0x4020000000000L, 0x8050000000000L, 0x110A0000000000L, 9592139440717824L, 19184278881435648L, 0x88500000000000L, 0x10A00000000000L, 0x20400000000000L};

    MinChessConstants() {
    }

    static short encodeMove(long fromPosition, long toPosition) {
        int fromIdx = Long.numberOfTrailingZeros(fromPosition);
        int fromFile = fromIdx % 8;
        int fromRank = fromIdx / 8;
        int binaryEncodedFrom = fromFile << 6 | fromRank << 9;
        int toIdx = Long.numberOfTrailingZeros(toPosition);
        int toFile = toIdx % 8;
        int toRank = toIdx / 8;
        int binaryEncodedTo = toFile | toRank << 3;
        return (short)(binaryEncodedFrom | binaryEncodedTo);
    }

    static short encodeMove(long fromPosition, long toPosition, int promotionPiece) {
        short fromToEncoded = MinChessConstants.encodeMove(fromPosition, toPosition);
        return (short)(promotionPiece << 12 | fromToEncoded);
    }
}

