/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import net.chesstango.gardel.fen.FEN;
import net.chesstango.gardel.fen.FENBuilder;
import net.chesstango.gardel.minchess.Bishop;
import net.chesstango.gardel.minchess.King;
import net.chesstango.gardel.minchess.Knight;
import net.chesstango.gardel.minchess.MinChessBuilder;
import net.chesstango.gardel.minchess.MinChessExporter;
import net.chesstango.gardel.minchess.MinChessWorkspace;
import net.chesstango.gardel.minchess.Pawn;
import net.chesstango.gardel.minchess.Rook;

public class MinChess
implements Cloneable {
    public static final int MAX_MOVES = 128;
    public static final int KNIGHT = 1;
    public static final int BISHOP = 2;
    public static final int ROOK = 3;
    public static final int QUEEN = 4;
    public static final int PAWN = 5;
    public static final int KING = 6;
    final MinChessWorkspace workspace;
    final MinChessWorkspace workspaceTmp;
    final King king;
    final Knight knight;
    final Rook rook;
    final Bishop bishop;
    final Pawn pawn;
    boolean validate = false;

    public MinChess(boolean whiteTurn, boolean castlingBlackKingAllowed, boolean castlingBlackQueenAllowed, boolean castlingWhiteKingAllowed, boolean castlingWhiteQueenAllowed, long enPassantSquare, long whitePositions, long blackPositions, long kingPositions, long queenPositions, long rookPositions, long bishopPositions, long knightPositions, long pawnPositions) {
        this.workspace = new MinChessWorkspace(whiteTurn, castlingBlackKingAllowed, castlingBlackQueenAllowed, castlingWhiteKingAllowed, castlingWhiteQueenAllowed, enPassantSquare, whitePositions, blackPositions, kingPositions, queenPositions, rookPositions, bishopPositions, knightPositions, pawnPositions, this);
        this.workspaceTmp = new MinChessWorkspace(this);
        this.king = new King(this::isLegalMove);
        this.knight = new Knight(this::isLegalMove);
        this.rook = new Rook(this::isLegalMove);
        this.bishop = new Bishop(this::isLegalMove);
        this.pawn = new Pawn(this::isLegalMove, this::isLegalEnPassantMove);
    }

    public int generateMoves(short[] moves) {
        int size = 0;
        size += this.king.generateMoves(this.workspace, moves, size);
        size += this.knight.generateMoves(this.workspace, moves, size);
        size += this.rook.generateMoves(this.workspace, moves, size);
        size += this.bishop.generateMoves(this.workspace, moves, size);
        size += this.pawn.generatePawnMoves(this.workspace, moves, size);
        return size;
    }

    public void doMove(short move) {
        int toFile = move & 7;
        int toRank = (move & 0x38) >>> 3;
        long toPosition = 1L << toRank * 8 + toFile;
        int fromRank = (move & 0xE00) >>> 9;
        int fromFile = (move & 0x1C0) >>> 6;
        long fromPosition = 1L << fromRank * 8 + fromFile;
        if ((fromPosition & this.workspace.pawnPositions) != 0L) {
            int promotionPiece = (move & 0x7000) >>> 12;
            if (promotionPiece != 0) {
                this.workspace.doMovePromotionImp(fromPosition, toPosition, promotionPiece);
            } else if (Math.abs(fromRank - toRank) == 2) {
                int enPassantRank = (fromRank + toRank) / 2;
                this.workspace.doMoveImp(fromPosition, toPosition);
                this.workspace.enPassantSquare = 1L << enPassantRank * 8 + fromFile;
            } else if ((toPosition & this.workspace.enPassantSquare) != 0L) {
                this.workspace.doEnPassantMoveImp(fromPosition, toPosition);
            } else {
                this.workspace.doMoveImp(fromPosition, toPosition);
            }
        } else if ((fromPosition & this.workspace.kingPositions) != 0L) {
            if (Math.abs(fromFile - toFile) == 2) {
                this.workspace.doCastlingMoveImp(fromPosition, toPosition);
            } else {
                this.workspace.doMoveImp(fromPosition, toPosition);
            }
        } else {
            this.workspace.doMoveImp(fromPosition, toPosition);
        }
        if (this.validate) {
            this.workspace.validate();
        }
    }

    public static int fromIdx(short move) {
        return MinChess.fromRank(move) * 8 + MinChess.fromFile(move);
    }

    public static int fromFile(short move) {
        return (move & 0x1C0) >>> 6;
    }

    public static int fromRank(short move) {
        return (move & 0xE00) >>> 9;
    }

    public static int toIdx(short move) {
        return MinChess.toRank(move) * 8 + MinChess.toFile(move);
    }

    public static int toFile(short move) {
        return move & 7;
    }

    public static int toRank(short move) {
        return (move & 0x38) >>> 3;
    }

    public static int getPromotionPiece(short move) {
        return (move & 0x7000) >>> 12;
    }

    public int getFromPiece(short move) {
        return this.getPiece(1L << MinChess.fromIdx(move));
    }

    public int getToPiece(short move) {
        return this.getPiece(1L << MinChess.toIdx(move));
    }

    public int getPiece(int file, int rank) {
        return this.getPiece(1L << rank * 8 + file);
    }

    public int getPiece(long position) {
        int piece = 0;
        if ((position & this.workspace.pawnPositions) != 0L) {
            piece = 5;
        } else if ((position & this.workspace.kingPositions) != 0L) {
            piece = 6;
        } else if ((position & this.workspace.queenPositions) != 0L) {
            piece = 4;
        } else if ((position & this.workspace.rookPositions) != 0L) {
            piece = 3;
        } else if ((position & this.workspace.bishopPositions) != 0L) {
            piece = 2;
        } else if ((position & this.workspace.knightPositions) != 0L) {
            piece = 1;
        }
        return piece;
    }

    public MinChess clone() {
        return new MinChess(this.workspace.whiteTurn, this.workspace.castlingBlackKingAllowed, this.workspace.castlingBlackQueenAllowed, this.workspace.castlingWhiteKingAllowed, this.workspace.castlingWhiteQueenAllowed, this.workspace.enPassantSquare, this.workspace.whitePositions, this.workspace.blackPositions, this.workspace.kingPositions, this.workspace.queenPositions, this.workspace.rookPositions, this.workspace.bishopPositions, this.workspace.knightPositions, this.workspace.pawnPositions);
    }

    boolean isLegalMove(long from, long to) {
        if (Long.bitCount(from) > 1 || Long.bitCount(to) > 1) {
            throw new RuntimeException("Invalid move: " + Long.toBinaryString(from) + " -> " + Long.toBinaryString(to));
        }
        this.workspaceTmp.copyFrom(this.workspace);
        this.workspaceTmp.doMoveImp(from, to);
        return !this.isKingInCheck(this.workspaceTmp, this.workspace.whiteTurn);
    }

    boolean isLegalEnPassantMove(long from, long enPassantSquare) {
        this.workspaceTmp.copyFrom(this.workspace);
        this.workspaceTmp.doEnPassantMoveImp(from, enPassantSquare);
        return !this.isKingInCheck(this.workspaceTmp, this.workspace.whiteTurn);
    }

    boolean isKingInCheck(MinChessWorkspace workspace, boolean turn) {
        int kingIdx;
        long kingPosition = workspace.kingPositions & (turn ? workspace.whitePositions : workspace.blackPositions);
        return this.king.isKingInCheckByOpponent(workspace, kingPosition, kingIdx = Long.numberOfTrailingZeros(kingPosition), !turn) || this.knight.isKingInCheckByOpponent(workspace, kingPosition, kingIdx, !turn) || this.rook.isKingInCheckByOpponent(workspace, kingPosition, kingIdx, !turn) || this.bishop.isKingInCheckByOpponent(workspace, kingPosition, kingIdx, !turn) || this.pawn.isKingInCheckByOpponentPawn(workspace, kingPosition, kingIdx, !turn);
    }

    public boolean getTurn() {
        return this.workspace.whiteTurn;
    }

    public static MinChess from(FEN fen) {
        MinChessBuilder builder = new MinChessBuilder();
        fen.export(builder);
        return builder.getPositionRepresentation();
    }

    public FEN toFEN() {
        FENBuilder fenBuilder = new FENBuilder();
        MinChessExporter exporter = new MinChessExporter(fenBuilder);
        exporter.export(this);
        return fenBuilder.getPositionRepresentation();
    }
}

