/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import java.util.function.BiPredicate;
import net.chesstango.gardel.minchess.AbstractPiece;
import net.chesstango.gardel.minchess.MinChessConstants;
import net.chesstango.gardel.minchess.MinChessWorkspace;

class Knight
extends AbstractPiece {
    Knight(BiPredicate<Long, Long> isLegalMoveFn) {
        super(isLegalMoveFn);
    }

    @Override
    int generateMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        long fromPosition;
        int size = 0;
        long emptyOrOpponentPositions = workspace.whiteTurn ? workspace.whitePositions ^ 0xFFFFFFFFFFFFFFFFL : workspace.blackPositions ^ 0xFFFFFFFFFFFFFFFFL;
        for (long knights = workspace.knightPositions & (workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions); knights != 0L; knights &= fromPosition ^ 0xFFFFFFFFFFFFFFFFL) {
            long toPosition;
            int fromIdx = Long.numberOfTrailingZeros(knights);
            fromPosition = 1L << fromIdx;
            long jumps = MinChessConstants.KNIGHT_JUMPS[fromIdx];
            for (long jumpPositions = jumps & emptyOrOpponentPositions; jumpPositions != 0L; jumpPositions &= toPosition ^ 0xFFFFFFFFFFFFFFFFL) {
                int jumpIdx = Long.numberOfTrailingZeros(jumpPositions);
                toPosition = 1L << jumpIdx;
                if (!this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            }
        }
        return size;
    }

    @Override
    boolean isKingInCheckByOpponent(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long kingJumps = MinChessConstants.KNIGHT_JUMPS[kingIdx];
        long knightPositionOpponent = workspace.knightPositions & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        return (kingJumps & knightPositionOpponent) != 0L;
    }
}

