/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import java.util.function.BiPredicate;
import net.chesstango.gardel.minchess.AbstractPiece;
import net.chesstango.gardel.minchess.MinChessConstants;
import net.chesstango.gardel.minchess.MinChessWorkspace;

class King
extends AbstractPiece {
    final long CASTLING_BLACK_KING = 0x6000000000000000L;
    final long CASTLING_BLACK_QUEEN = 0xE00000000000000L;
    final long CASTLING_WHITE_KING = 96L;
    final long CASTLING_WHITE_QUEEN = 14L;

    King(BiPredicate<Long, Long> isLegalMoveFn) {
        super(isLegalMoveFn);
    }

    @Override
    int generateMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        int size = 0;
        size += this.generateJumpMoves(workspace, moves, size);
        size += this.generateCastlingMoves(workspace, moves, size);
        return size;
    }

    int generateCastlingMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        return workspace.whiteTurn ? this.generateWhiteCastlingMoves(workspace, moves, startIdx) : this.generateBlackCastlingMoves(workspace, moves, startIdx);
    }

    int generateBlackCastlingMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        int size = 0;
        if (!workspace.isKingInCheck(false)) {
            long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
            long fromPosition = workspace.blackPositions & workspace.kingPositions;
            if (workspace.castlingBlackKingAllowed && (0x6000000000000000L & emptyPositions) == 0x6000000000000000L && this.isLegalMoveFn.test(fromPosition, 0x2000000000000000L) && this.isLegalMoveFn.test(fromPosition, 0x4000000000000000L)) {
                moves[startIdx + size++] = MinChessConstants.encodeMove(fromPosition, 0x4000000000000000L);
            }
            if (workspace.castlingBlackQueenAllowed && (0xE00000000000000L & emptyPositions) == 0xE00000000000000L && this.isLegalMoveFn.test(fromPosition, 0x400000000000000L) && this.isLegalMoveFn.test(fromPosition, 0x800000000000000L)) {
                moves[startIdx + size++] = MinChessConstants.encodeMove(fromPosition, 0x400000000000000L);
            }
        }
        return size;
    }

    int generateWhiteCastlingMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        int size = 0;
        if (!workspace.isKingInCheck(true)) {
            long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
            long fromPosition = workspace.whitePositions & workspace.kingPositions;
            if (workspace.castlingWhiteKingAllowed && (0x60L & emptyPositions) == 96L && this.isLegalMoveFn.test(fromPosition, 32L) && this.isLegalMoveFn.test(fromPosition, 64L)) {
                moves[startIdx + size++] = MinChessConstants.encodeMove(fromPosition, 64L);
            }
            if (workspace.castlingWhiteQueenAllowed && (0xEL & emptyPositions) == 14L && this.isLegalMoveFn.test(fromPosition, 4L) && this.isLegalMoveFn.test(fromPosition, 8L)) {
                moves[startIdx + size++] = MinChessConstants.encodeMove(fromPosition, 4L);
            }
        }
        return size;
    }

    int generateJumpMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        long toPosition;
        int size = 0;
        long emptyOrOpponentPositions = workspace.whiteTurn ? workspace.whitePositions ^ 0xFFFFFFFFFFFFFFFFL : workspace.blackPositions ^ 0xFFFFFFFFFFFFFFFFL;
        long fromPosition = workspace.kingPositions & (workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions);
        int fromIdx = Long.numberOfTrailingZeros(fromPosition);
        long jumps = MinChessConstants.KING_JUMPS[fromIdx];
        for (long jumpPositions = jumps & emptyOrOpponentPositions; jumpPositions != 0L; jumpPositions &= toPosition ^ 0xFFFFFFFFFFFFFFFFL) {
            int jumpIdx = Long.numberOfTrailingZeros(jumpPositions);
            toPosition = 1L << jumpIdx;
            if (!this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
            moves[startIdx + size++] = MinChessConstants.encodeMove(fromPosition, toPosition);
        }
        return size;
    }

    @Override
    boolean isKingInCheckByOpponent(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long kingJumps = MinChessConstants.KING_JUMPS[kingIdx];
        long kingPositionOpponent = workspace.kingPositions & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        return (kingJumps & kingPositionOpponent) != 0L;
    }
}

