/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.minchess;

import java.util.function.BiPredicate;
import net.chesstango.gardel.minchess.AbstractPiece;
import net.chesstango.gardel.minchess.MinChessConstants;
import net.chesstango.gardel.minchess.MinChessWorkspace;

class Bishop
extends AbstractPiece {
    Bishop(BiPredicate<Long, Long> isLegalMoveFn) {
        super(isLegalMoveFn);
    }

    @Override
    int generateMoves(MinChessWorkspace workspace, short[] moves, int startIdx) {
        long from;
        int size = 0;
        for (long fromBishops = (workspace.bishopPositions | workspace.queenPositions) & (workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions); fromBishops != 0L; fromBishops &= from ^ 0xFFFFFFFFFFFFFFFFL) {
            from = 1L << Long.numberOfTrailingZeros(fromBishops);
            size += this.generateBishopMovesNorthWest(workspace, moves, startIdx + size, from);
            size += this.generateBishopMovesNorthEast(workspace, moves, startIdx + size, from);
            size += this.generateBishopMovesSouthWest(workspace, moves, startIdx + size, from);
            size += this.generateBishopMovesSouthEast(workspace, moves, startIdx + size, from);
        }
        return size;
    }

    int generateBishopMovesNorthWest(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0xFF01010101010101L) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition <<= 7) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0xFF01010101010101L) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    int generateBishopMovesNorthEast(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0xFF80808080808080L) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition <<= 9) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0xFF80808080808080L) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    int generateBishopMovesSouthWest(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0x1010101010101FFL) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition >>>= 9) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0x1010101010101FFL) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    int generateBishopMovesSouthEast(MinChessWorkspace workspace, short[] moves, int startIdx, long fromPosition) {
        long ownPositions;
        int size = 0;
        long allPositions = workspace.whitePositions | workspace.blackPositions;
        long l = ownPositions = workspace.whiteTurn ? workspace.whitePositions : workspace.blackPositions;
        if ((fromPosition & 0x80808080808080FFL) == 0L) {
            long toPosition = fromPosition;
            do {
                if (((toPosition >>>= 7) & ownPositions) != 0L || !this.isLegalMoveFn.test(fromPosition, toPosition)) continue;
                moves[startIdx + size] = MinChessConstants.encodeMove(fromPosition, toPosition);
                ++size;
            } while ((toPosition & 0x80808080808080FFL) == 0L && (toPosition & allPositions) == 0L);
        }
        return size;
    }

    @Override
    boolean isKingInCheckByOpponent(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        return this.isKingInCheckByOpponentBishopNorthWest(workspace, kingPosition, kingIdx, opponentColor) || this.isKingInCheckByOpponentBishopNorthEast(workspace, kingPosition, kingIdx, opponentColor) || this.isKingInCheckByOpponentBishopSouthWest(workspace, kingPosition, kingIdx, opponentColor) || this.isKingInCheckByOpponentBishopSouthEast(workspace, kingPosition, kingIdx, opponentColor);
    }

    boolean isKingInCheckByOpponentBishopNorthWest(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentBishops = (workspace.bishopPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0xFF01010101010101L) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition <<= 7) & opponentBishops) == 0L) continue;
                return true;
            } while ((toPosition & 0xFF01010101010101L) == 0L && (toPosition & emptyPositions) != 0L);
        }
        return false;
    }

    boolean isKingInCheckByOpponentBishopNorthEast(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentBishops = (workspace.bishopPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0xFF80808080808080L) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition <<= 9) & opponentBishops) == 0L) continue;
                return true;
            } while ((toPosition & 0xFF80808080808080L) == 0L && (toPosition & emptyPositions) != 0L);
        }
        return false;
    }

    boolean isKingInCheckByOpponentBishopSouthWest(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentBishops = (workspace.bishopPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0x1010101010101FFL) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition >>>= 9) & opponentBishops) == 0L) continue;
                return true;
            } while ((toPosition & 0x1010101010101FFL) == 0L && (toPosition & emptyPositions) != 0L);
        }
        return false;
    }

    boolean isKingInCheckByOpponentBishopSouthEast(MinChessWorkspace workspace, long kingPosition, int kingIdx, boolean opponentColor) {
        long emptyPositions = (workspace.whitePositions | workspace.blackPositions) ^ 0xFFFFFFFFFFFFFFFFL;
        long opponentBishops = (workspace.bishopPositions | workspace.queenPositions) & (opponentColor ? workspace.whitePositions : workspace.blackPositions);
        if ((kingPosition & 0x80808080808080FFL) == 0L) {
            long toPosition = kingPosition;
            do {
                if (((toPosition >>>= 7) & opponentBishops) == 0L) continue;
                return true;
            } while ((toPosition & 0x80808080808080FFL) == 0L && (toPosition & emptyPositions) != 0L);
        }
        return false;
    }
}

