/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.fen;

import net.chesstango.gardel.fen.AbstractFENBuilder;

class FENStringBuilder
extends AbstractFENBuilder<String> {
    boolean ignoreEnPassantSquareIfNotCapturePresente;
    boolean ignoreClocks;

    FENStringBuilder() {
    }

    @Override
    public String getPositionRepresentation() {
        String piecePlacement = this.getPiecePlacement();
        String activeColor = this.getTurno();
        String castingsAllowed = this.getEnroques();
        String enPassantSquare = this.getEnPassant();
        String halfMoveClock = this.getHalfMoveClock();
        String fullMoveClock = this.getFullMoveClock();
        StringBuilder sb = new StringBuilder();
        sb.append(piecePlacement);
        sb.append(" ").append(activeColor);
        sb.append(" ").append(castingsAllowed);
        if (this.ignoreEnPassantSquareIfNotCapturePresente) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        sb.append(" ").append(enPassantSquare);
        if (!this.ignoreClocks) {
            sb.append(" ").append(halfMoveClock);
            sb.append(" ").append(fullMoveClock);
        }
        return sb.toString();
    }

    public void setIgnoreEnPassantSquareIfNotCapturePresente(boolean ignoreEnPassantSquareIfNotCapturePresente) {
        this.ignoreEnPassantSquareIfNotCapturePresente = ignoreEnPassantSquareIfNotCapturePresente;
    }

    public void setIgnoreClocks(boolean ignoreClocks) {
        this.ignoreClocks = ignoreClocks;
    }
}

