/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.fen;

import net.chesstango.gardel.PositionBuilder;
import net.chesstango.gardel.fen.FEN;

class FENExporter {
    private final PositionBuilder<?> positionBuilder;

    FENExporter(PositionBuilder<?> positionBuilder) {
        this.positionBuilder = positionBuilder;
    }

    void export(FEN fen) {
        this.positionBuilder.withWhiteTurn(this.parseTurn(fen.getActiveColor()));
        this.parsePiecePlacement(fen.getPiecePlacement());
        if (this.isCastlingWhiteQueenAllowed(fen.getCastingsAllowed())) {
            this.positionBuilder.withCastlingWhiteQueenAllowed(true);
        }
        if (this.isCastlingWhiteKingAllowed(fen.getCastingsAllowed())) {
            this.positionBuilder.withCastlingWhiteKingAllowed(true);
        }
        if (this.isCastlingBlackQueenAllowed(fen.getCastingsAllowed())) {
            this.positionBuilder.withCastlingBlackQueenAllowed(true);
        }
        if (this.isCastlingBlackKingAllowed(fen.getCastingsAllowed())) {
            this.positionBuilder.withCastlingBlackKingAllowed(true);
        }
        if (!"-".equals(fen.getEnPassantSquare())) {
            this.positionBuilder.withEnPassantSquare(this.parseFileEnPassantSquare(fen.getEnPassantSquare()), this.parseRankEnPassantSquare(fen.getEnPassantSquare()));
        }
        this.positionBuilder.withHalfMoveClock(Integer.parseInt(fen.getHalfMoveClock()));
        this.positionBuilder.withFullMoveClock(Integer.parseInt(fen.getFullMoveClock()));
    }

    void parsePiecePlacement(String piecePlacement) {
        int rank = 7;
        int file = 0;
        int idx = 0;
        block16: while (idx < piecePlacement.length()) {
            char currentChar = piecePlacement.charAt(idx++);
            switch (currentChar) {
                case 'K': {
                    this.positionBuilder.withWhiteKing(file++, rank);
                    continue block16;
                }
                case 'Q': {
                    this.positionBuilder.withWhiteQueen(file++, rank);
                    continue block16;
                }
                case 'R': {
                    this.positionBuilder.withWhiteRook(file++, rank);
                    continue block16;
                }
                case 'B': {
                    this.positionBuilder.withWhiteBishop(file++, rank);
                    continue block16;
                }
                case 'N': {
                    this.positionBuilder.withWhiteKnight(file++, rank);
                    continue block16;
                }
                case 'P': {
                    this.positionBuilder.withWhitePawn(file++, rank);
                    continue block16;
                }
                case 'k': {
                    this.positionBuilder.withBlackKing(file++, rank);
                    continue block16;
                }
                case 'q': {
                    this.positionBuilder.withBlackQueen(file++, rank);
                    continue block16;
                }
                case 'r': {
                    this.positionBuilder.withBlackRook(file++, rank);
                    continue block16;
                }
                case 'b': {
                    this.positionBuilder.withBlackBishop(file++, rank);
                    continue block16;
                }
                case 'n': {
                    this.positionBuilder.withBlackKnight(file++, rank);
                    continue block16;
                }
                case 'p': {
                    this.positionBuilder.withBlackPawn(file++, rank);
                    continue block16;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': {
                    file += Integer.parseInt(String.valueOf(currentChar));
                    continue block16;
                }
                case '/': {
                    --rank;
                    file = 0;
                    continue block16;
                }
            }
            throw new RuntimeException("FEN: Malformed piece placement: " + piecePlacement);
        }
    }

    int parseFileEnPassantSquare(String pawnPasante) {
        if (!"-".equals(pawnPasante)) {
            char file = pawnPasante.charAt(0);
            return switch (file) {
                case 'a' -> 0;
                case 'b' -> 1;
                case 'c' -> 2;
                case 'd' -> 3;
                case 'e' -> 4;
                case 'f' -> 5;
                case 'g' -> 6;
                case 'h' -> 7;
                default -> throw new IllegalArgumentException("Invalid EnPassantSquare");
            };
        }
        throw new IllegalArgumentException("Invalid EnPassantSquare");
    }

    int parseRankEnPassantSquare(String pawnPasante) {
        if (!"-".equals(pawnPasante)) {
            char rank = pawnPasante.charAt(1);
            return Integer.parseInt(String.valueOf(rank)) - 1;
        }
        throw new IllegalArgumentException("Invalid EnPassantSquare");
    }

    boolean parseTurn(String activeColor) {
        return 'w' == activeColor.charAt(0);
    }

    boolean isCastlingWhiteQueenAllowed(String castlingAllowed) {
        return castlingAllowed.contains("Q");
    }

    boolean isCastlingWhiteKingAllowed(String castlingAllowed) {
        return castlingAllowed.contains("K");
    }

    boolean isCastlingBlackQueenAllowed(String castlingAllowed) {
        return castlingAllowed.contains("q");
    }

    boolean isCastlingBlackKingAllowed(String castlingAllowed) {
        return castlingAllowed.contains("k");
    }
}

