/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.fen;

import java.io.Serializable;
import java.util.Objects;
import net.chesstango.gardel.PositionBuilder;
import net.chesstango.gardel.PositionExporter;
import net.chesstango.gardel.fen.FENExporter;
import net.chesstango.gardel.fen.FENParser;

public final class FEN
implements PositionExporter,
Serializable {
    private final String piecePlacement;
    private final String activeColor;
    private final String castingsAllowed;
    private final String enPassantSquare;
    private final String halfMoveClock;
    private final String fullMoveClock;

    FEN(String piecePlacement, String activeColor, String castingsAllowed, String enPassantSquare, String halfMoveClock, String fullMoveClock) {
        this.piecePlacement = piecePlacement;
        this.activeColor = activeColor;
        this.castingsAllowed = castingsAllowed;
        this.enPassantSquare = enPassantSquare;
        this.halfMoveClock = halfMoveClock;
        this.fullMoveClock = fullMoveClock;
    }

    public static FEN of(String fenString) {
        FENParser parser = new FENParser();
        return parser.parseFEN(fenString);
    }

    @Override
    public <T> void export(PositionBuilder<T> positionBuilder) {
        FENExporter fenExporter = new FENExporter(positionBuilder);
        fenExporter.export(this);
    }

    public String toString() {
        return String.format("%s %s %s %s %s %s", this.piecePlacement, this.activeColor, this.castingsAllowed, this.enPassantSquare, this.halfMoveClock, this.fullMoveClock);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FEN)) {
            return false;
        }
        FEN fen = (FEN)o;
        return Objects.equals(this.piecePlacement, fen.piecePlacement) && Objects.equals(this.activeColor, fen.activeColor) && Objects.equals(this.castingsAllowed, fen.castingsAllowed) && Objects.equals(this.enPassantSquare, fen.enPassantSquare) && Objects.equals(this.halfMoveClock, fen.halfMoveClock) && Objects.equals(this.fullMoveClock, fen.fullMoveClock);
    }

    public int hashCode() {
        return Objects.hash(this.piecePlacement, this.activeColor, this.castingsAllowed, this.enPassantSquare, this.halfMoveClock, this.fullMoveClock);
    }

    public String getPiecePlacement() {
        return this.piecePlacement;
    }

    public String getActiveColor() {
        return this.activeColor;
    }

    public String getCastingsAllowed() {
        return this.castingsAllowed;
    }

    public String getEnPassantSquare() {
        return this.enPassantSquare;
    }

    public String getHalfMoveClock() {
        return this.halfMoveClock;
    }

    public String getFullMoveClock() {
        return this.fullMoveClock;
    }
}

