/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.fen;

import net.chesstango.gardel.AbstractPositionBuilder;

public abstract class AbstractFENBuilder<T>
extends AbstractPositionBuilder<T> {
    String getHalfMoveClock() {
        return Integer.toString(this.halfMoveClock);
    }

    String getFullMoveClock() {
        return Integer.toString(this.fullMoveClock);
    }

    String getTurno() {
        return this.whiteTurn ? "w" : "b";
    }

    String getPiecePlacement() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int rank = 7; rank >= 0; --rank) {
            int emptySquares = 0;
            for (int file = 0; file < 8; ++file) {
                long position = 1L << rank * 8 + file;
                char piece = this.getChar(position);
                if (piece == ' ') {
                    ++emptySquares;
                    continue;
                }
                if (emptySquares > 0) {
                    stringBuilder.append(emptySquares);
                    emptySquares = 0;
                }
                stringBuilder.append(piece);
            }
            if (emptySquares > 0) {
                stringBuilder.append(emptySquares);
            }
            if (rank <= 0) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    String getEnPassant() {
        if (this.enPassantSquare != 0L) {
            return AbstractFENBuilder.enPassantSquareToString(this.enPassantSquare);
        }
        return "-";
    }

    String getEnroques() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.castlingWhiteKingAllowed) {
            stringBuilder.append('K');
        }
        if (this.castlingWhiteQueenAllowed) {
            stringBuilder.append('Q');
        }
        if (this.castlingBlackKingAllowed) {
            stringBuilder.append('k');
        }
        if (this.castlingBlackQueenAllowed) {
            stringBuilder.append('q');
        }
        if (!(this.castlingWhiteKingAllowed || this.castlingWhiteQueenAllowed || this.castlingBlackKingAllowed || this.castlingBlackQueenAllowed)) {
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    public static String enPassantSquareToString(long enPassantSquare) {
        int enPassantSquarePosition = Long.numberOfTrailingZeros(enPassantSquare);
        if (enPassantSquarePosition == 64) {
            return "-";
        }
        int file = enPassantSquarePosition % 8;
        int rank = enPassantSquarePosition / 8;
        char fileChar = (char)(97 + file);
        char rankChar = rank == 0 ? (char)'1' : (rank == 7 ? (char)'8' : (char)(49 + rank));
        return String.valueOf(new char[]{fileChar, rankChar});
    }

    private char getChar(long position) {
        if ((this.whitePositions & this.kingPositions & position) != 0L) {
            return 'K';
        }
        if ((this.whitePositions & this.queenPositions & position) != 0L) {
            return 'Q';
        }
        if ((this.whitePositions & this.rookPositions & position) != 0L) {
            return 'R';
        }
        if ((this.whitePositions & this.bishopPositions & position) != 0L) {
            return 'B';
        }
        if ((this.whitePositions & this.knightPositions & position) != 0L) {
            return 'N';
        }
        if ((this.whitePositions & this.pawnPositions & position) != 0L) {
            return 'P';
        }
        if ((this.blackPositions & this.kingPositions & position) != 0L) {
            return 'k';
        }
        if ((this.blackPositions & this.queenPositions & position) != 0L) {
            return 'q';
        }
        if ((this.blackPositions & this.rookPositions & position) != 0L) {
            return 'r';
        }
        if ((this.blackPositions & this.bishopPositions & position) != 0L) {
            return 'b';
        }
        if ((this.blackPositions & this.knightPositions & position) != 0L) {
            return 'n';
        }
        if ((this.blackPositions & this.pawnPositions & position) != 0L) {
            return 'p';
        }
        return ' ';
    }
}

