/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.epd;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.chesstango.gardel.epd.EPDEncoder;
import net.chesstango.gardel.fen.FEN;
import net.chesstango.gardel.move.AgregateMoveDecoder;
import net.chesstango.gardel.move.Move;

public class EPD {
    private String text;
    private String piecePlacement;
    private String activeColor;
    private String castingsAllowed;
    private String enPassantSquare;
    private String id;
    private String c0;
    private String c1;
    private String c2;
    private String c3;
    private String c4;
    private String c5;
    private String c6;
    private String c7;
    private String bestMovesStr;
    private String avoidMovesStr;
    private String suppliedMoveStr;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EPD epd = (EPD)object;
        return Objects.equals(this.getText(), epd.getText());
    }

    public int hashCode() {
        return Objects.hash(this.getText());
    }

    public String toString() {
        return this.text != null ? this.text : new EPDEncoder().encode(this);
    }

    public String getFenWithoutClocks() {
        return this.piecePlacement + " " + this.activeColor + " " + this.castingsAllowed + " " + this.enPassantSquare;
    }

    public boolean isMoveSuccess(String move) {
        if (this.bestMovesStr != null && !this.bestMovesStr.isEmpty()) {
            return this.isMoveSuccess(move, this.bestMovesStr);
        }
        if (this.avoidMovesStr != null && !this.avoidMovesStr.isEmpty()) {
            return this.isMoveSuccess(move, this.avoidMovesStr);
        }
        if (this.suppliedMoveStr != null && !this.suppliedMoveStr.isEmpty()) {
            return this.isMoveSuccess(move, this.suppliedMoveStr);
        }
        throw new RuntimeException("Undefined expected EPD result");
    }

    boolean isMoveSuccess(String moveStr, String movesListStr) {
        Move theMove = Move.of(moveStr);
        List<Move> moveList = this.movesStringToMoves(movesListStr);
        for (Move move : moveList) {
            if (!move.equals(theMove)) continue;
            return true;
        }
        return false;
    }

    List<Move> movesStringToMoves(String movesString) {
        FEN fen = FEN.of(this.getFenWithoutClocks() + " 0 1");
        String[] movesStringArray = movesString.split(" ");
        ArrayList<Move> moveList = new ArrayList<Move>(movesStringArray.length);
        AgregateMoveDecoder<Move> moveDecoder = new AgregateMoveDecoder<Move>(new Move.GardelMoveSupplier());
        for (String moveStr : movesStringArray) {
            Move move = moveDecoder.decode(moveStr, fen);
            if (move == null) {
                throw new RuntimeException(String.format("Unable to find move %s", moveStr));
            }
            moveList.add(move);
        }
        return moveList;
    }

    public String getText() {
        return this.text;
    }

    public String getPiecePlacement() {
        return this.piecePlacement;
    }

    public String getActiveColor() {
        return this.activeColor;
    }

    public String getCastingsAllowed() {
        return this.castingsAllowed;
    }

    public String getEnPassantSquare() {
        return this.enPassantSquare;
    }

    public String getId() {
        return this.id;
    }

    public String getC0() {
        return this.c0;
    }

    public String getC1() {
        return this.c1;
    }

    public String getC2() {
        return this.c2;
    }

    public String getC3() {
        return this.c3;
    }

    public String getC4() {
        return this.c4;
    }

    public String getC5() {
        return this.c5;
    }

    public String getC6() {
        return this.c6;
    }

    public String getC7() {
        return this.c7;
    }

    public String getBestMovesStr() {
        return this.bestMovesStr;
    }

    public String getAvoidMovesStr() {
        return this.avoidMovesStr;
    }

    public String getSuppliedMoveStr() {
        return this.suppliedMoveStr;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPiecePlacement(String piecePlacement) {
        this.piecePlacement = piecePlacement;
    }

    public void setActiveColor(String activeColor) {
        this.activeColor = activeColor;
    }

    public void setCastingsAllowed(String castingsAllowed) {
        this.castingsAllowed = castingsAllowed;
    }

    public void setEnPassantSquare(String enPassantSquare) {
        this.enPassantSquare = enPassantSquare;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setC0(String c0) {
        this.c0 = c0;
    }

    public void setC1(String c1) {
        this.c1 = c1;
    }

    public void setC2(String c2) {
        this.c2 = c2;
    }

    public void setC3(String c3) {
        this.c3 = c3;
    }

    public void setC4(String c4) {
        this.c4 = c4;
    }

    public void setC5(String c5) {
        this.c5 = c5;
    }

    public void setC6(String c6) {
        this.c6 = c6;
    }

    public void setC7(String c7) {
        this.c7 = c7;
    }

    public void setBestMovesStr(String bestMovesStr) {
        this.bestMovesStr = bestMovesStr;
    }

    public void setAvoidMovesStr(String avoidMovesStr) {
        this.avoidMovesStr = avoidMovesStr;
    }

    public void setSuppliedMoveStr(String suppliedMoveStr) {
        this.suppliedMoveStr = suppliedMoveStr;
    }
}

