/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel.ascii;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.chesstango.gardel.AbstractPositionBuilder;
import net.chesstango.gardel.fen.FENBuilder;

public class ASCIIBuilder
extends AbstractPositionBuilder<String> {
    private FENBuilder fenBuilder = new FENBuilder();

    @Override
    public String getPositionRepresentation() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(baos);){
            this.printPiecePlacement(ps);
            this.printFEN(ps);
        }
        return baos.toString();
    }

    public void printFEN(PrintStream printStream) {
        printStream.printf("FEN: %s%n", this.fenBuilder.getPositionRepresentation());
    }

    public void printPiecePlacement(PrintStream printStream) {
        printStream.println("  -------------------------------");
        for (int rank = 7; rank >= 0; --rank) {
            for (int file = 0; file < 8; ++file) {
                if (file == 0) {
                    printStream.print(rank + 1);
                }
                long position = 1L << rank * 8 + file;
                printStream.print("| " + this.getChar(position) + " ");
                if (file != 7) continue;
                printStream.println("|");
                printStream.println("  -------------------------------");
            }
        }
        printStream.println("   a   b   c   d   e   f   g   h");
        printStream.flush();
    }

    private char getChar(long position) {
        if ((this.whitePositions & this.kingPositions & position) != 0L) {
            return 'K';
        }
        if ((this.whitePositions & this.queenPositions & position) != 0L) {
            return 'Q';
        }
        if ((this.whitePositions & this.rookPositions & position) != 0L) {
            return 'R';
        }
        if ((this.whitePositions & this.bishopPositions & position) != 0L) {
            return 'B';
        }
        if ((this.whitePositions & this.knightPositions & position) != 0L) {
            return 'N';
        }
        if ((this.whitePositions & this.pawnPositions & position) != 0L) {
            return 'P';
        }
        if ((this.blackPositions & this.kingPositions & position) != 0L) {
            return 'k';
        }
        if ((this.blackPositions & this.queenPositions & position) != 0L) {
            return 'q';
        }
        if ((this.blackPositions & this.rookPositions & position) != 0L) {
            return 'r';
        }
        if ((this.blackPositions & this.bishopPositions & position) != 0L) {
            return 'b';
        }
        if ((this.blackPositions & this.knightPositions & position) != 0L) {
            return 'n';
        }
        if ((this.blackPositions & this.pawnPositions & position) != 0L) {
            return 'p';
        }
        return ' ';
    }

    @Override
    public ASCIIBuilder withWhiteTurn(boolean whiteTurn) {
        super.withWhiteTurn(whiteTurn);
        this.fenBuilder.withWhiteTurn(whiteTurn);
        return this;
    }

    @Override
    public ASCIIBuilder withWhiteKing(int file, int rank) {
        super.withWhiteKing(file, rank);
        this.fenBuilder.withWhiteKing(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withWhiteQueen(int file, int rank) {
        super.withWhiteQueen(file, rank);
        this.fenBuilder.withWhiteQueen(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withWhiteRook(int file, int rank) {
        super.withWhiteRook(file, rank);
        this.fenBuilder.withWhiteRook(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withWhiteBishop(int file, int rank) {
        super.withWhiteBishop(file, rank);
        this.fenBuilder.withWhiteBishop(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withWhiteKnight(int file, int rank) {
        super.withWhiteKnight(file, rank);
        this.fenBuilder.withWhiteKnight(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withWhitePawn(int file, int rank) {
        super.withWhitePawn(file, rank);
        this.fenBuilder.withWhitePawn(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withBlackKing(int file, int rank) {
        super.withBlackKing(file, rank);
        this.fenBuilder.withBlackKing(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withBlackQueen(int file, int rank) {
        super.withBlackQueen(file, rank);
        this.fenBuilder.withBlackQueen(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withBlackRook(int file, int rank) {
        super.withBlackRook(file, rank);
        this.fenBuilder.withBlackRook(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withBlackBishop(int file, int rank) {
        super.withBlackBishop(file, rank);
        this.fenBuilder.withBlackBishop(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withBlackKnight(int file, int rank) {
        super.withBlackKnight(file, rank);
        this.fenBuilder.withBlackKnight(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withBlackPawn(int file, int rank) {
        super.withBlackPawn(file, rank);
        this.fenBuilder.withBlackPawn(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withEnPassantSquare(int file, int rank) {
        super.withEnPassantSquare(file, rank);
        this.fenBuilder.withEnPassantSquare(file, rank);
        return this;
    }

    @Override
    public ASCIIBuilder withCastlingBlackKingAllowed(boolean castlingBlackKingAllowed) {
        super.withCastlingBlackKingAllowed(castlingBlackKingAllowed);
        this.fenBuilder.withCastlingBlackKingAllowed(castlingBlackKingAllowed);
        return this;
    }

    @Override
    public ASCIIBuilder withCastlingBlackQueenAllowed(boolean castlingBlackQueenAllowed) {
        super.withCastlingBlackQueenAllowed(castlingBlackQueenAllowed);
        this.fenBuilder.withCastlingBlackQueenAllowed(castlingBlackQueenAllowed);
        return this;
    }

    @Override
    public ASCIIBuilder withCastlingWhiteKingAllowed(boolean castlingWhiteKingAllowed) {
        super.withCastlingWhiteKingAllowed(castlingWhiteKingAllowed);
        this.fenBuilder.withCastlingWhiteKingAllowed(castlingWhiteKingAllowed);
        return this;
    }

    @Override
    public ASCIIBuilder withCastlingWhiteQueenAllowed(boolean castlingWhiteQueenAllowed) {
        super.withCastlingWhiteQueenAllowed(castlingWhiteQueenAllowed);
        this.fenBuilder.withCastlingWhiteQueenAllowed(castlingWhiteQueenAllowed);
        return this;
    }

    @Override
    public ASCIIBuilder withHalfMoveClock(int halfMoveClock) {
        super.withHalfMoveClock(halfMoveClock);
        this.fenBuilder.withHalfMoveClock(halfMoveClock);
        return this;
    }

    @Override
    public ASCIIBuilder withFullMoveClock(int fullMoveClock) {
        super.withFullMoveClock(fullMoveClock);
        this.fenBuilder.withFullMoveClock(fullMoveClock);
        return this;
    }
}

