/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel;

import net.chesstango.gardel.PositionBuilder;

public class MirrorPositionBuilder<T>
implements PositionBuilder<T> {
    private final PositionBuilder<T> positionBuilder;

    public MirrorPositionBuilder(PositionBuilder<T> positionBuilder) {
        this.positionBuilder = positionBuilder;
    }

    @Override
    public MirrorPositionBuilder<T> withWhiteTurn(boolean whiteTurn) {
        this.positionBuilder.withWhiteTurn(!whiteTurn);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withWhiteKing(int file, int rank) {
        this.positionBuilder.withBlackKing(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withWhiteQueen(int file, int rank) {
        this.positionBuilder.withBlackQueen(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withWhiteRook(int file, int rank) {
        this.positionBuilder.withBlackRook(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withWhiteBishop(int file, int rank) {
        this.positionBuilder.withBlackBishop(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withWhiteKnight(int file, int rank) {
        this.positionBuilder.withBlackKnight(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withWhitePawn(int file, int rank) {
        this.positionBuilder.withBlackPawn(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withBlackKing(int file, int rank) {
        this.positionBuilder.withWhiteKing(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withBlackQueen(int file, int rank) {
        this.positionBuilder.withWhiteQueen(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withBlackRook(int file, int rank) {
        this.positionBuilder.withWhiteRook(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withBlackBishop(int file, int rank) {
        this.positionBuilder.withWhiteBishop(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withBlackKnight(int file, int rank) {
        this.positionBuilder.withWhiteKnight(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withBlackPawn(int file, int rank) {
        this.positionBuilder.withWhitePawn(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withEnPassantSquare(int file, int rank) {
        this.positionBuilder.withEnPassantSquare(file, 7 - rank);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withCastlingWhiteQueenAllowed(boolean castlingWhiteQueenAllowed) {
        this.positionBuilder.withCastlingBlackQueenAllowed(castlingWhiteQueenAllowed);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withCastlingWhiteKingAllowed(boolean castlingWhiteKingAllowed) {
        this.positionBuilder.withCastlingBlackKingAllowed(castlingWhiteKingAllowed);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withCastlingBlackQueenAllowed(boolean castlingBlackQueenAllowed) {
        this.positionBuilder.withCastlingWhiteQueenAllowed(castlingBlackQueenAllowed);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withCastlingBlackKingAllowed(boolean castlingBlackKingAllowed) {
        this.positionBuilder.withCastlingWhiteKingAllowed(castlingBlackKingAllowed);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withHalfMoveClock(int halfMoveClock) {
        this.positionBuilder.withHalfMoveClock(halfMoveClock);
        return this;
    }

    @Override
    public MirrorPositionBuilder<T> withFullMoveClock(int fullMoveClock) {
        this.positionBuilder.withFullMoveClock(fullMoveClock);
        return this;
    }

    @Override
    public T getPositionRepresentation() {
        return this.positionBuilder.getPositionRepresentation();
    }
}

