/*
 * Decompiled with CFR 0.152.
 */
package net.chesstango.gardel;

import net.chesstango.gardel.PositionBuilder;

public abstract class AbstractPositionBuilder<T>
implements PositionBuilder<T> {
    protected boolean whiteTurn;
    protected boolean castlingBlackKingAllowed;
    protected boolean castlingBlackQueenAllowed;
    protected boolean castlingWhiteKingAllowed;
    protected boolean castlingWhiteQueenAllowed;
    protected int halfMoveClock;
    protected int fullMoveClock;
    protected long enPassantSquare = 0L;
    protected long whitePositions = 0L;
    protected long blackPositions = 0L;
    protected long kingPositions = 0L;
    protected long queenPositions = 0L;
    protected long rookPositions = 0L;
    protected long bishopPositions = 0L;
    protected long knightPositions = 0L;
    protected long pawnPositions = 0L;

    @Override
    public AbstractPositionBuilder<T> withWhiteTurn(boolean whiteTurn) {
        this.whiteTurn = whiteTurn;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withWhiteKing(int file, int rank) {
        int square = rank * 8 + file;
        this.whitePositions |= 1L << square;
        this.kingPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withWhiteQueen(int file, int rank) {
        int square = rank * 8 + file;
        this.whitePositions |= 1L << square;
        this.queenPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withWhiteRook(int file, int rank) {
        int square = rank * 8 + file;
        this.whitePositions |= 1L << square;
        this.rookPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withWhiteBishop(int file, int rank) {
        int square = rank * 8 + file;
        this.whitePositions |= 1L << square;
        this.bishopPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withWhiteKnight(int file, int rank) {
        int square = rank * 8 + file;
        this.whitePositions |= 1L << square;
        this.knightPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withWhitePawn(int file, int rank) {
        int square = rank * 8 + file;
        this.whitePositions |= 1L << square;
        this.pawnPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withBlackKing(int file, int rank) {
        int square = rank * 8 + file;
        this.blackPositions |= 1L << square;
        this.kingPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withBlackQueen(int file, int rank) {
        int square = rank * 8 + file;
        this.blackPositions |= 1L << square;
        this.queenPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withBlackRook(int file, int rank) {
        int square = rank * 8 + file;
        this.blackPositions |= 1L << square;
        this.rookPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withBlackBishop(int file, int rank) {
        int square = rank * 8 + file;
        this.blackPositions |= 1L << square;
        this.bishopPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withBlackKnight(int file, int rank) {
        int square = rank * 8 + file;
        this.blackPositions |= 1L << square;
        this.knightPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withBlackPawn(int file, int rank) {
        int square = rank * 8 + file;
        this.blackPositions |= 1L << square;
        this.pawnPositions |= 1L << square;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withEnPassantSquare(int file, int rank) {
        this.enPassantSquare = 1L << rank * 8 + file;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withCastlingBlackKingAllowed(boolean castlingBlackKingAllowed) {
        this.castlingBlackKingAllowed = castlingBlackKingAllowed;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withCastlingBlackQueenAllowed(boolean castlingBlackQueenAllowed) {
        this.castlingBlackQueenAllowed = castlingBlackQueenAllowed;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withCastlingWhiteKingAllowed(boolean castlingWhiteKingAllowed) {
        this.castlingWhiteKingAllowed = castlingWhiteKingAllowed;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withCastlingWhiteQueenAllowed(boolean castlingWhiteQueenAllowed) {
        this.castlingWhiteQueenAllowed = castlingWhiteQueenAllowed;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withHalfMoveClock(int halfMoveClock) {
        this.halfMoveClock = halfMoveClock;
        return this;
    }

    @Override
    public AbstractPositionBuilder<T> withFullMoveClock(int fullMoveClock) {
        this.fullMoveClock = fullMoveClock;
        return this;
    }
}

