/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.util;

import com.codahale.metrics.Gauge;
import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtil {
    private static final Logger logger = LoggerFactory.getLogger(JmxUtil.class);
    private static MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    private JmxUtil() {
    }

    public static <T> Gauge<T> getJmxAttributeAsGauge(final ObjectName targetObjectName, final String attributeName, final Class<T> attributeClass, final T gaugeDefaultValue) {
        Preconditions.checkNotNull((Object)targetObjectName);
        Preconditions.checkNotNull((Object)attributeName);
        Preconditions.checkNotNull(attributeClass);
        Object value = null;
        try {
            value = mBeanServer.getAttribute(targetObjectName, attributeName);
        }
        catch (Exception e) {
            logger.debug("Error while looking up attribute {} in the {} MxBean", new Object[]{attributeName, targetObjectName.getKeyPropertyListString(), e});
            if (InterruptedException.class.isInstance(e)) {
                Thread.currentThread().interrupt();
            }
            return null;
        }
        if (!attributeClass.isInstance(value)) {
            logger.debug("JMX attribute {} in the {} MxBean is of unexpected type: {}", new Object[]{attributeName, targetObjectName.getKeyPropertyListString(), value != null ? value.getClass().getSimpleName() : null});
            return null;
        }
        return new Gauge<T>(){

            public T getValue() {
                try {
                    return attributeClass.cast(mBeanServer.getAttribute(targetObjectName, attributeName));
                }
                catch (Exception ignore) {
                    return gaugeDefaultValue;
                }
            }
        };
    }

    public static <T> T getJmxAttribute(ObjectName targetObjectName, String attributeName, Class<T> attributeClass, T defaultValue) {
        Preconditions.checkNotNull((Object)targetObjectName);
        Preconditions.checkNotNull((Object)attributeName);
        Preconditions.checkNotNull(attributeClass);
        Object value = null;
        try {
            value = mBeanServer.getAttribute(targetObjectName, attributeName);
        }
        catch (Exception e) {
            logger.debug("Error while looking up attribute {} in the {} MxBean", new Object[]{attributeName, targetObjectName.getKeyPropertyListString(), e});
            if (InterruptedException.class.isInstance(e)) {
                Thread.currentThread().interrupt();
            }
            return defaultValue;
        }
        if (attributeClass.isInstance(value)) {
            return attributeClass.cast(value);
        }
        return defaultValue;
    }
}

