/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ThreadDeadlockDetector;
import com.google.common.base.CaseFormat;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ThreadMetricSet
implements MetricSet {
    private static final int STACK_TRACE_DEPTH = 0;
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private ThreadDeadlockDetector deadlockDetector = new ThreadDeadlockDetector();
    private Gauge<Integer> currentThreadsGauge;
    private Gauge<Integer> peakThreadsGauge;
    private Gauge<Integer> daemonThreadsGauge;
    private Gauge<Integer> deadlockedThreadsGauge;
    private Map<Thread.State, Gauge<Integer>> threadsGaugesByThreadStates;
    private Map<String, Metric> metricsByNames;

    ThreadMetricSet() {
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        this.currentThreadsGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return ThreadMetricSet.this.threadMXBean.getThreadCount();
            }
        };
        metricsByNames.put("currentCount", (Metric)this.currentThreadsGauge);
        this.peakThreadsGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return ThreadMetricSet.this.threadMXBean.getPeakThreadCount();
            }
        };
        metricsByNames.put("peakCount", (Metric)this.peakThreadsGauge);
        this.daemonThreadsGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return ThreadMetricSet.this.threadMXBean.getPeakThreadCount();
            }
        };
        metricsByNames.put("daemons", (Metric)this.daemonThreadsGauge);
        this.deadlockedThreadsGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return ThreadMetricSet.this.deadlockDetector.getDeadlockedThreads().size();
            }
        };
        metricsByNames.put("deadlocked", (Metric)this.deadlockedThreadsGauge);
        HashMap<Thread.State, Gauge<Integer>> threadsGaugesByThreadStates = new HashMap<Thread.State, Gauge<Integer>>();
        for (final Thread.State state : Thread.State.values()) {
            String metricName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, state.toString());
            Gauge<Integer> threadsGauge = new Gauge<Integer>(){

                public Integer getValue() {
                    return ThreadMetricSet.this.getThreadCount(state);
                }
            };
            threadsGaugesByThreadStates.put(state, threadsGauge);
            metricsByNames.put(metricName, (Metric)threadsGauge);
        }
        this.threadsGaugesByThreadStates = threadsGaugesByThreadStates;
        this.metricsByNames = metricsByNames;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    Gauge<Integer> getDeadlockedThreadsGauge() {
        return this.deadlockedThreadsGauge;
    }

    Gauge<Integer> getDaemonThreadsGauge() {
        return this.daemonThreadsGauge;
    }

    Gauge<Integer> getPeakThreadsGauge() {
        return this.peakThreadsGauge;
    }

    Gauge<Integer> getCurrentThreadsGauge() {
        return this.currentThreadsGauge;
    }

    Map<Thread.State, Gauge<Integer>> getThreadsGaugesByThreadStates() {
        return Collections.unmodifiableMap(this.threadsGaugesByThreadStates);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.threadMXBean.getThreadInfo(this.threadMXBean.getAllThreadIds(), 0);
        int count = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }
}

