/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.BufferPoolMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.BufferPoolStatus;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.ClassLoadingMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.GarbageCollectorMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.GarbageCollectorStatus;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.JvmMemoryMetricSet;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.JvmStatus;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.MemoryPoolStatus;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.MemoryUsageStatus;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.ThreadMetricSet;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class JvmMetricSet
implements MetricSet,
JvmStatus {
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private BufferPoolMetricSet bufferPoolMetricSet;
    private ClassLoadingMetricSet classLoadingMetricSet;
    private ThreadMetricSet threadMetricSet;
    private JvmMemoryMetricSet memoryMetricSet;
    private GarbageCollectorMetricSet gcMetricSet;
    private Gauge<Long> uptimeInMillisGauge;
    private Map<String, Metric> metricsByNames;
    private AtomicBoolean shutdown;

    public JvmMetricSet() {
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        this.bufferPoolMetricSet = new BufferPoolMetricSet();
        metricsByNames.put("bufferPools", (Metric)this.bufferPoolMetricSet);
        this.classLoadingMetricSet = new ClassLoadingMetricSet();
        metricsByNames.put("classes", (Metric)this.classLoadingMetricSet);
        this.threadMetricSet = new ThreadMetricSet();
        metricsByNames.put("threads", (Metric)this.threadMetricSet);
        this.memoryMetricSet = new JvmMemoryMetricSet();
        metricsByNames.put("memory", (Metric)this.memoryMetricSet);
        this.gcMetricSet = new GarbageCollectorMetricSet();
        metricsByNames.put("gc", (Metric)this.gcMetricSet);
        this.uptimeInMillisGauge = new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricSet.this.runtimeMXBean.getUptime();
            }
        };
        metricsByNames.put("uptimeInMillis", (Metric)this.uptimeInMillisGauge);
        this.metricsByNames = metricsByNames;
        this.shutdown = new AtomicBoolean(false);
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    @Override
    @JsonProperty
    public List<BufferPoolStatus> getBufferPoolStatuses() {
        return this.bufferPoolMetricSet.getBufferPoolStatuses();
    }

    @Override
    @JsonProperty
    public Gauge<Long> getTotalLoadedClassesGauge() {
        return this.classLoadingMetricSet.getTotalLoadedClassesGauge();
    }

    @Override
    @JsonProperty
    public Gauge<Long> getUnloadedClassesGauge() {
        return this.classLoadingMetricSet.getUnloadedClassesGauge();
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getCurrentlyLoadedClassesGauge() {
        return this.classLoadingMetricSet.getCurrentlyLoadedClassesGauge();
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getCurrentThreadsGauge() {
        return this.threadMetricSet.getCurrentThreadsGauge();
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getPeakThreadsGauge() {
        return this.threadMetricSet.getPeakThreadsGauge();
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getDaemonThreadsGauge() {
        return this.threadMetricSet.getDaemonThreadsGauge();
    }

    @Override
    @JsonProperty
    public Gauge<Integer> getDeadlockedThreadsGauge() {
        return this.threadMetricSet.getDeadlockedThreadsGauge();
    }

    @Override
    @JsonProperty
    public Map<Thread.State, Gauge<Integer>> getThreadsGaugesByThreadStates() {
        return this.threadMetricSet.getThreadsGaugesByThreadStates();
    }

    @Override
    @JsonProperty
    public MemoryUsageStatus getTotalMemoryUsageStatus() {
        return this.memoryMetricSet.getTotalMemoryUsageStatus();
    }

    @Override
    @JsonProperty
    public MemoryUsageStatus getHeapMemoryUsageStatus() {
        return this.memoryMetricSet.getHeapMemoryUsageStatus();
    }

    @Override
    @JsonProperty
    public MemoryUsageStatus getNonHeapMemoryUsageStatus() {
        return this.memoryMetricSet.getNonHeapMemoryUsageStatus();
    }

    @Override
    @JsonProperty
    public List<MemoryPoolStatus> getMemoryPoolStatuses() {
        return this.memoryMetricSet.getMemoryPoolStatuses();
    }

    @Override
    @JsonProperty
    public List<GarbageCollectorStatus> getGarbageCollectorStatuses() {
        return this.gcMetricSet.getGarbageCollectorStatuses();
    }

    @Override
    @JsonProperty
    public Timer getMinorGcTimer() {
        return this.gcMetricSet.getMinorGcTimer();
    }

    @Override
    @JsonProperty
    public Timer getMajorGcTimer() {
        return this.gcMetricSet.getMajorGcTimer();
    }

    @Override
    @JsonProperty
    public Gauge<Long> getFullGcCollectionsGauge() {
        return this.gcMetricSet.getFullCollectionsGauge();
    }

    @Override
    @JsonProperty
    public Gauge<Long> getUptimeInMillisGauge() {
        return this.uptimeInMillisGauge;
    }

    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.gcMetricSet.shutdown();
    }
}

