/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.system.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.sun.management.GarbageCollectionNotificationInfo;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import net.centro.rtb.monitoringcenter.metrics.forwarding.ForwardingReadOnlyTimer;
import net.centro.rtb.monitoringcenter.metrics.system.jvm.GarbageCollectorStatus;
import net.centro.rtb.monitoringcenter.util.MetricNamingUtil;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;

class GarbageCollectorMetricSet
implements MetricSet {
    private static final String LOG_GC_JVM_PARAM = "-Xloggc:";
    private static final long GC_LOG_FILE_TAIL_DELAY_IN_MILLIS = 5000L;
    private static final String FULL_GC_LOG_STRING = "Full GC";
    private static final String GC_NOTIFICATION_MINOR_GC_ACTION_STRING = "end of minor GC";
    private static final String GC_NOTIFICATION_MAJOR_GC_ACTION_STRING = "end of major GC";
    private List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private NotificationListener gcEventListener;
    private Tailer gcLogTailer;
    private AtomicLong fullCollectionsCounter;
    private Gauge<Long> fullCollectionsGauge;
    private Timer minorGcTimer = new Timer();
    private Timer majorGcTimer = new Timer();
    private List<GarbageCollectorStatus> garbageCollectorStatuses;
    private Map<String, Metric> metricsByNames;

    GarbageCollectorMetricSet() {
        Object gcLogFile;
        String gcLogFilePath = null;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        for (String argument : inputArguments) {
            if (!argument.startsWith(LOG_GC_JVM_PARAM)) continue;
            gcLogFilePath = argument.substring(LOG_GC_JVM_PARAM.length());
            break;
        }
        if (gcLogFilePath != null && !gcLogFilePath.trim().isEmpty() && ((File)(gcLogFile = new File(gcLogFilePath))).exists()) {
            this.fullCollectionsCounter = new AtomicLong();
            this.gcLogTailer = Tailer.create((File)gcLogFile, (TailerListener)new TailerListenerAdapter(){

                public void handle(String line) {
                    if (line != null && line.contains(GarbageCollectorMetricSet.FULL_GC_LOG_STRING)) {
                        GarbageCollectorMetricSet.this.fullCollectionsCounter.incrementAndGet();
                    }
                }
            }, (long)5000L);
        }
        this.gcEventListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                String notificationType = notification.getType();
                if (notificationType.equals("com.sun.management.gc.notification")) {
                    CompositeData compositeData = (CompositeData)CompositeData.class.cast(notification.getUserData());
                    GarbageCollectionNotificationInfo gcNotificationInfo = GarbageCollectionNotificationInfo.from(compositeData);
                    if (GarbageCollectorMetricSet.GC_NOTIFICATION_MINOR_GC_ACTION_STRING.equals(gcNotificationInfo.getGcAction())) {
                        GarbageCollectorMetricSet.this.minorGcTimer.update(gcNotificationInfo.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
                    } else if (GarbageCollectorMetricSet.GC_NOTIFICATION_MAJOR_GC_ACTION_STRING.equals(gcNotificationInfo.getGcAction())) {
                        GarbageCollectorMetricSet.this.majorGcTimer.update(gcNotificationInfo.getGcInfo().getDuration(), TimeUnit.MILLISECONDS);
                    }
                }
            }
        };
        for (GarbageCollectorMXBean garbageCollectorMXBean : this.garbageCollectorMXBeans) {
            if (!NotificationEmitter.class.isInstance(garbageCollectorMXBean)) continue;
            NotificationEmitter emitter = (NotificationEmitter)NotificationEmitter.class.cast(garbageCollectorMXBean);
            emitter.addNotificationListener(this.gcEventListener, null, null);
        }
        HashMap<String, Metric> metricsByNames = new HashMap<String, Metric>();
        if (this.fullCollectionsCounter != null) {
            this.fullCollectionsGauge = new Gauge<Long>(){

                public Long getValue() {
                    return GarbageCollectorMetricSet.this.fullCollectionsCounter.get();
                }
            };
            metricsByNames.put("fullCollections", (Metric)this.fullCollectionsGauge);
        }
        metricsByNames.put("majorGcTimer", (Metric)this.majorGcTimer);
        metricsByNames.put("minorGcTimer", (Metric)this.minorGcTimer);
        ArrayList<GarbageCollectorStatus> garbageCollectorStatuses = new ArrayList<GarbageCollectorStatus>();
        for (final GarbageCollectorMXBean garbageCollectorMXBean : this.garbageCollectorMXBeans) {
            Gauge<Long> totalCollectionDurationInMillisGauge;
            Gauge<Long> collectionsGauge;
            final String garbageCollectorName = garbageCollectorMXBean.getName();
            String garbageCollectorNamespace = MetricNamingUtil.join("collectors", MetricNamingUtil.sanitize(garbageCollectorName));
            if (garbageCollectorMXBean.getCollectionCount() >= 0L) {
                collectionsGauge = new Gauge<Long>(){

                    public Long getValue() {
                        return garbageCollectorMXBean.getCollectionCount();
                    }
                };
                metricsByNames.put(MetricNamingUtil.join(garbageCollectorNamespace, "collections"), (Metric)collectionsGauge);
            } else {
                collectionsGauge = null;
            }
            if (garbageCollectorMXBean.getCollectionTime() >= 0L) {
                totalCollectionDurationInMillisGauge = new Gauge<Long>(){

                    public Long getValue() {
                        return garbageCollectorMXBean.getCollectionTime();
                    }
                };
                metricsByNames.put(MetricNamingUtil.join(garbageCollectorNamespace, "totalCollectionDurationInMillis"), (Metric)totalCollectionDurationInMillisGauge);
            } else {
                totalCollectionDurationInMillisGauge = null;
            }
            garbageCollectorStatuses.add(new GarbageCollectorStatus((Gauge)collectionsGauge, (Gauge)totalCollectionDurationInMillisGauge){
                final /* synthetic */ Gauge val$collectionsGauge;
                final /* synthetic */ Gauge val$totalCollectionDurationInMillisGauge;
                {
                    this.val$collectionsGauge = gauge;
                    this.val$totalCollectionDurationInMillisGauge = gauge2;
                }

                @Override
                public String getName() {
                    return garbageCollectorName;
                }

                @Override
                public Gauge<Long> getCollectionsGauge() {
                    return this.val$collectionsGauge;
                }

                @Override
                public Gauge<Long> getTotalCollectionDurationInMillisGauge() {
                    return this.val$totalCollectionDurationInMillisGauge;
                }
            });
        }
        this.garbageCollectorStatuses = garbageCollectorStatuses;
        this.metricsByNames = metricsByNames;
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metricsByNames);
    }

    Gauge<Long> getFullCollectionsGauge() {
        return this.fullCollectionsGauge;
    }

    Timer getMinorGcTimer() {
        return new ForwardingReadOnlyTimer(this.minorGcTimer);
    }

    Timer getMajorGcTimer() {
        return new ForwardingReadOnlyTimer(this.majorGcTimer);
    }

    List<GarbageCollectorStatus> getGarbageCollectorStatuses() {
        return Collections.unmodifiableList(this.garbageCollectorStatuses);
    }

    public void shutdown() {
        if (this.gcLogTailer != null) {
            this.gcLogTailer.stop();
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : this.garbageCollectorMXBeans) {
            if (!NotificationEmitter.class.isInstance(garbageCollectorMXBean)) continue;
            NotificationEmitter emitter = (NotificationEmitter)NotificationEmitter.class.cast(garbageCollectorMXBean);
            try {
                emitter.removeNotificationListener(this.gcEventListener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {}
        }
    }
}

