/*
 * Decompiled with CFR 0.152.
 */
package net.centro.rtb.monitoringcenter.metrics.instrumented;

import com.codahale.metrics.Timer;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.centro.rtb.monitoringcenter.MetricCollector;

public class InstrumentedDataSource
implements DataSource {
    private DataSource delegate;
    private Timer connectionAcquisitionTimer;

    public InstrumentedDataSource(DataSource delegate, MetricCollector metricCollector, String name) {
        this.delegate = delegate;
        this.connectionAcquisitionTimer = metricCollector.getTimer(name, "connectionAcquisitionTimer");
    }

    @Override
    public Connection getConnection() throws SQLException {
        Timer.Context context = this.connectionAcquisitionTimer.time();
        try {
            Connection connection = this.delegate.getConnection();
            return connection;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Timer.Context context = this.connectionAcquisitionTimer.time();
        try {
            Connection connection = this.delegate.getConnection(username, password);
            return connection;
        }
        finally {
            context.stop();
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }
}

